"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExplorationResults = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _mlDataGrid = require("@kbn/ml-data-grid");
var _kibana = require("../../../../../contexts/kibana");
var _data_loader = require("../../../../../datavisualizer/index_based/data_loader");
var _common = require("../../../../common");
var _trained_models = require("../../../../../services/ml_api_service/trained_models");
var _use_exploration_data_grid = require("./use_exploration_data_grid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useExplorationResults = (dataView, jobConfig, searchQuery) => {
  var _jobConfig$dest$resul;
  const {
    services: {
      notifications: {
        toasts
      }
    }
  } = (0, _kibana.useMlKibana)();
  const mlApi = (0, _kibana.useMlApi)();
  const [baseline, setBaseLine] = (0, _react.useState)();
  const trainedModelsApiService = (0, _trained_models.useTrainedModelsApiService)();
  const needsDestIndexFields = dataView !== undefined && dataView.title === (jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.source.index[0]);
  const columns = [];
  if (jobConfig !== undefined) {
    const resultsField = jobConfig.dest.results_field;
    const {
      fieldTypes
    } = (0, _common.getIndexFields)(mlApi, jobConfig, needsDestIndexFields);
    columns.push(...(0, _mlDataGrid.getDataGridSchemasFromFieldTypes)(fieldTypes, resultsField).sort((a, b) => (0, _mlDataFrameAnalyticsUtils.sortExplorationResultsFields)(a.id, b.id, jobConfig)));
  }
  const dataGrid = (0, _use_exploration_data_grid.useExplorationDataGrid)(columns,
  // reduce default selected rows from 20 to 8 for performance reasons.
  8,
  // by default, hide feature-importance and top-classes columns and the doc id copy
  d => !d.includes(`.${_mlDataFrameAnalyticsUtils.FEATURE_IMPORTANCE}.`) && !d.includes(`.${_mlDataFrameAnalyticsUtils.TOP_CLASSES}.`) && d !== _mlDataFrameAnalyticsUtils.ML__ID_COPY);

  // The pattern using `didCancel` allows us to abort out of date remote request.
  // We wrap `didCancel` in a object so we can mutate the value as it's being
  // passed on to `getIndexData`.
  (0, _react.useEffect)(() => {
    const options = {
      didCancel: false
    };
    (0, _common.getIndexData)(mlApi, jobConfig, dataGrid, searchQuery, options);
    return () => {
      options.didCancel = true;
    };
    // custom comparison
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobConfig && jobConfig.id, dataGrid.pagination, searchQuery, dataGrid.sortingColumns]);
  const dataLoader = (0, _react.useMemo)(() => dataView !== undefined ? new _data_loader.DataLoader(dataView, mlApi) : undefined,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [dataView]);
  const fetchColumnChartsData = async function () {
    try {
      if (jobConfig !== undefined && dataLoader !== undefined) {
        const columnChartsData = await dataLoader.loadFieldHistograms(columns.filter(cT => dataGrid.visibleColumns.includes(cT.id)).map(cT => ({
          fieldName: cT.id,
          type: (0, _mlDataGrid.getFieldType)(cT.schema)
        })), searchQuery);
        dataGrid.setColumnCharts(columnChartsData);
      }
    } catch (e) {
      (0, _mlDataGrid.showDataGridColumnChartErrorMessageToast)(e, toasts);
    }
  };
  (0, _react.useEffect)(() => {
    if (dataGrid.chartsVisible) {
      fetchColumnChartsData();
    }
    // custom comparison
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dataGrid.chartsVisible, jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.dest.index,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  JSON.stringify([searchQuery, dataGrid.visibleColumns])]);
  const predictionFieldName = (0, _react.useMemo)(() => {
    if (jobConfig) {
      var _getPredictionFieldNa;
      return (_getPredictionFieldNa = (0, _mlDataFrameAnalyticsUtils.getPredictionFieldName)(jobConfig.analysis)) !== null && _getPredictionFieldNa !== void 0 ? _getPredictionFieldNa : (0, _mlDataFrameAnalyticsUtils.getDefaultPredictionFieldName)(jobConfig.analysis);
    }
    return undefined;
  }, [jobConfig]);
  const getAnalyticsBaseline = (0, _react.useCallback)(async () => {
    try {
      if (jobConfig !== undefined && jobConfig.analysis !== undefined && ((0, _mlDataFrameAnalyticsUtils.isRegressionAnalysis)(jobConfig.analysis) || (0, _mlDataFrameAnalyticsUtils.isClassificationAnalysis)(jobConfig.analysis))) {
        var _inferenceModel$metad;
        const jobId = jobConfig.id;
        const inferenceModels = await trainedModelsApiService.getTrainedModels(`${jobId}*`, {
          include: 'feature_importance_baseline'
        });
        const inferenceModel = inferenceModels.find(model => {
          var _model$metadata, _model$metadata$analy;
          return ((_model$metadata = model.metadata) === null || _model$metadata === void 0 ? void 0 : (_model$metadata$analy = _model$metadata.analytics_config) === null || _model$metadata$analy === void 0 ? void 0 : _model$metadata$analy.id) === jobId;
        });
        if ((inferenceModel === null || inferenceModel === void 0 ? void 0 : (_inferenceModel$metad = inferenceModel.metadata) === null || _inferenceModel$metad === void 0 ? void 0 : _inferenceModel$metad.feature_importance_baseline) !== undefined) {
          var _inferenceModel$metad2;
          setBaseLine(inferenceModel === null || inferenceModel === void 0 ? void 0 : (_inferenceModel$metad2 = inferenceModel.metadata) === null || _inferenceModel$metad2 === void 0 ? void 0 : _inferenceModel$metad2.feature_importance_baseline);
        }
      }
    } catch (e) {
      const error = (0, _mlErrorUtils.extractErrorMessage)(e);
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.explorationResults.baselineErrorMessageToast', {
          defaultMessage: 'An error occurred getting feature importance baseline'
        }),
        text: error
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobConfig]);
  (0, _react.useEffect)(() => {
    getAnalyticsBaseline();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobConfig]);
  const resultsField = (_jobConfig$dest$resul = jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.dest.results_field) !== null && _jobConfig$dest$resul !== void 0 ? _jobConfig$dest$resul : _mlDataFrameAnalyticsUtils.DEFAULT_RESULTS_FIELD;
  const renderCellValue = (0, _mlDataGrid.useRenderCellValue)(dataView, dataGrid.pagination, dataGrid.tableItems, resultsField);
  return {
    ...dataGrid,
    renderCellValue,
    baseline,
    predictionFieldName,
    resultsField
  };
};
exports.useExplorationResults = useExplorationResults;