"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuntimeMappings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlRuntimeFieldUtils = require("@kbn/ml-runtime-field-utils");
var _ml = require("../../../../../contexts/ml");
var _runtime_mappings_editor = require("./runtime_mappings_editor");
var _switch_modal = require("./switch_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/runtime_mappings/runtime_mappings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const advancedEditorsSidebarWidth = '220px';
const COPY_RUNTIME_FIELDS_TO_CLIPBOARD_TEXT = _i18n.i18n.translate('xpack.ml.dataframe.analytics.createWizard.indexPreview.copyRuntimeMappingsClipboardTooltip', {
  defaultMessage: 'Copy Dev Console statement of the runtime fields to the clipboard.'
});
const APPLY_CHANGES_TEXT = _i18n.i18n.translate('xpack.ml.dataframe.analytics.createWizard.advancedSourceEditorApplyButtonText', {
  defaultMessage: 'Apply changes'
});
const RUNTIME_FIELDS_EDITOR_HELP_TEXT = _i18n.i18n.translate('xpack.ml.dataframe.analytics.createWizard.advancedRuntimeFieldsEditorHelpText', {
  defaultMessage: 'The advanced editor allows you to edit the runtime fields of the source.'
});
const EDIT_SWITCH_LABEL_TEXT = _i18n.i18n.translate('xpack.ml.dataframe.analytics.createWizard.advancedEditorRuntimeFieldsSwitchLabel', {
  defaultMessage: 'Edit runtime fields'
});
const RUNTIME_FIELDS_LABEL_TEXT = _i18n.i18n.translate('xpack.ml.dataframe.analytics.createWizard.runtimeFieldsLabel', {
  defaultMessage: 'Runtime fields'
});
const {
  useXJsonMode
} = _public.XJson;
const RuntimeMappings = ({
  actions,
  state
}) => {
  const [isRuntimeMappingsEditorEnabled, setIsRuntimeMappingsEditorEnabled] = (0, _react.useState)(false);
  const [isRuntimeMappingsEditorSwitchModalVisible, setRuntimeMappingsEditorSwitchModalVisible] = (0, _react.useState)(false);
  const [isRuntimeMappingsEditorApplyButtonEnabled, setIsRuntimeMappingsEditorApplyButtonEnabled] = (0, _react.useState)(false);
  const [advancedEditorRuntimeMappingsLastApplied, setAdvancedEditorRuntimeMappingsLastApplied] = (0, _react.useState)();
  const {
    setFormState
  } = actions;
  const {
    jobType,
    previousRuntimeMapping,
    runtimeMappings
  } = state.form;
  const {
    convertToJson,
    setXJson: setAdvancedRuntimeMappingsConfig,
    xJson: advancedRuntimeMappingsConfig
  } = useXJsonMode(runtimeMappings || '');
  const {
    selectedDataView
  } = (0, _ml.useDataSource)();
  const applyChanges = () => {
    const removeRuntimeMappings = advancedRuntimeMappingsConfig === '';
    const parsedRuntimeMappings = removeRuntimeMappings ? undefined : JSON.parse(advancedRuntimeMappingsConfig);
    const prettySourceConfig = removeRuntimeMappings ? '' : JSON.stringify(parsedRuntimeMappings, null, 2);
    const previous = previousRuntimeMapping === undefined && runtimeMappings === undefined ? parsedRuntimeMappings : runtimeMappings;
    setFormState({
      runtimeMappings: parsedRuntimeMappings,
      runtimeMappingsUpdated: true,
      previousRuntimeMapping: previous
    });
    setAdvancedRuntimeMappingsConfig(prettySourceConfig);
    setAdvancedEditorRuntimeMappingsLastApplied(prettySourceConfig);
    setIsRuntimeMappingsEditorApplyButtonEnabled(false);
  };
  const toggleEditorHandler = (reset = false) => {
    if (reset === true) {
      setFormState({
        runtimeMappingsUpdated: false
      });
      setAdvancedRuntimeMappingsConfig(advancedEditorRuntimeMappingsLastApplied !== null && advancedEditorRuntimeMappingsLastApplied !== void 0 ? advancedEditorRuntimeMappingsLastApplied : '');
    }
    setIsRuntimeMappingsEditorEnabled(!isRuntimeMappingsEditorEnabled);
    setIsRuntimeMappingsEditorApplyButtonEnabled((0, _mlRuntimeFieldUtils.isRuntimeMappings)(runtimeMappings));
  };
  (0, _react.useEffect)(function getInitialRuntimeMappings() {
    const combinedRuntimeMappings = (0, _mlRuntimeFieldUtils.getCombinedRuntimeMappings)(selectedDataView, runtimeMappings);
    const prettySourceConfig = JSON.stringify(combinedRuntimeMappings, null, 2);
    if (combinedRuntimeMappings) {
      setAdvancedRuntimeMappingsConfig(prettySourceConfig);
      setAdvancedEditorRuntimeMappingsLastApplied(prettySourceConfig);
      setFormState({
        runtimeMappings: combinedRuntimeMappings
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: RUNTIME_FIELDS_LABEL_TEXT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }, (0, _mlIsPopulatedObject.isPopulatedObject)(runtimeMappings) ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  }, Object.keys(runtimeMappings).join(',')) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.createWizard.noRuntimeFieldLabel",
    defaultMessage: "No runtime field",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 15
    }
  }), isRuntimeMappingsEditorEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_runtime_mappings_editor.RuntimeMappingsEditor, {
    advancedEditorRuntimeMappingsLastApplied: advancedEditorRuntimeMappingsLastApplied,
    advancedRuntimeMappingsConfig: advancedRuntimeMappingsConfig,
    setIsRuntimeMappingsEditorApplyButtonEnabled: setIsRuntimeMappingsEditorApplyButtonEnabled,
    setAdvancedRuntimeMappingsConfig: setAdvancedRuntimeMappingsConfig,
    convertToJson: convertToJson,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: advancedEditorsSidebarWidth
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    disabled: jobType === undefined,
    label: EDIT_SWITCH_LABEL_TEXT,
    checked: isRuntimeMappingsEditorEnabled,
    onChange: () => {
      if (isRuntimeMappingsEditorEnabled && advancedRuntimeMappingsConfig !== advancedEditorRuntimeMappingsLastApplied) {
        setRuntimeMappingsEditorSwitchModalVisible(true);
        return;
      }
      toggleEditorHandler();
    },
    "data-test-subj": "mlDataFrameAnalyticsRuntimeMappingsEditorSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 21
    }
  }), isRuntimeMappingsEditorSwitchModalVisible && /*#__PURE__*/_react.default.createElement(_switch_modal.SwitchModal, {
    onCancel: () => setRuntimeMappingsEditorSwitchModalVisible(false),
    onConfirm: () => {
      setRuntimeMappingsEditorSwitchModalVisible(false);
      toggleEditorHandler(true);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    beforeMessage: COPY_RUNTIME_FIELDS_TO_CLIPBOARD_TEXT,
    textToCopy: advancedRuntimeMappingsConfig !== null && advancedRuntimeMappingsConfig !== void 0 ? advancedRuntimeMappingsConfig : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 21
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: copy,
    iconType: "copyClipboard",
    "aria-label": COPY_RUNTIME_FIELDS_TO_CLIPBOARD_TEXT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 25
    }
  }))))), isRuntimeMappingsEditorEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: advancedEditorsSidebarWidth
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 19
    }
  }, RUNTIME_FIELDS_EDITOR_HELP_TEXT), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    style: {
      width: 'fit-content'
    },
    size: "s",
    fill: true,
    onClick: applyChanges,
    disabled: !isRuntimeMappingsEditorApplyButtonEnabled,
    "data-test-subj": "mlDataFrameAnalyticsRuntimeMappingsApplyButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 19
    }
  }, APPLY_CHANGES_TEXT)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 7
    }
  }));
};
exports.RuntimeMappings = RuntimeMappings;