"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResultsViewConfig = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _kibana = require("../../contexts/kibana");
var _new_job_capabilities_service_analytics = require("../../services/new_job_capabilities/new_job_capabilities_service_analytics");
var _index_service = require("../../util/index_service");
var _get_analytics = require("../pages/analytics_management/services/analytics_service/get_analytics");
var _trained_models = require("../../services/ml_api_service/trained_models");
var _toast_notification_service = require("../../services/toast_notification_service");
var _get_destination_index = require("./get_destination_index");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useResultsViewConfig = jobId => {
  const {
    services: {
      data: {
        dataViews
      }
    }
  } = (0, _kibana.useMlKibana)();
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();
  const mlApi = (0, _kibana.useMlApi)();
  const {
    getDataViewIdFromName
  } = (0, _index_service.useMlIndexUtils)();
  const trainedModelsApiService = (0, _trained_models.useTrainedModelsApiService)();
  const newJobCapsServiceAnalytics = (0, _new_job_capabilities_service_analytics.useNewJobCapsServiceAnalytics)();
  const [dataView, setDataView] = (0, _react.useState)(undefined);
  const [dataViewErrorMessage, setDataViewErrorMessage] = (0, _react.useState)(undefined);
  const [isInitialized, setIsInitialized] = (0, _react.useState)(false);
  const [needsDestDataView, setNeedsDestDataView] = (0, _react.useState)(false);
  const [isLoadingJobConfig, setIsLoadingJobConfig] = (0, _react.useState)(false);
  const [jobConfig, setJobConfig] = (0, _react.useState)(undefined);
  const [jobCapsServiceErrorMessage, setJobCapsServiceErrorMessage] = (0, _react.useState)(undefined);
  const [jobConfigErrorMessage, setJobConfigErrorMessage] = (0, _react.useState)(undefined);
  const [jobStatus, setJobStatus] = (0, _react.useState)(undefined);
  const [totalFeatureImportance, setTotalFeatureImportance] = (0, _react.useState)(undefined);

  // get analytics configuration, data view and field caps
  (0, _react.useEffect)(() => {
    (async function () {
      setIsLoadingJobConfig(false);
      try {
        const analyticsConfigs = await mlApi.dataFrameAnalytics.getDataFrameAnalytics(jobId);
        const analyticsStats = await mlApi.dataFrameAnalytics.getDataFrameAnalyticsStats(jobId);
        const stats = (0, _get_analytics.isGetDataFrameAnalyticsStatsResponseOk)(analyticsStats) ? analyticsStats.data_frame_analytics[0] : undefined;
        if (stats !== undefined && stats.state) {
          setJobStatus(stats.state);
        }
        if (Array.isArray(analyticsConfigs.data_frame_analytics) && analyticsConfigs.data_frame_analytics.length > 0) {
          const jobConfigUpdate = analyticsConfigs.data_frame_analytics[0];
          // don't fetch the total feature importance if it's outlier_detection
          if ((0, _mlDataFrameAnalyticsUtils.isClassificationAnalysis)(jobConfigUpdate.analysis) || (0, _mlDataFrameAnalyticsUtils.isRegressionAnalysis)(jobConfigUpdate.analysis)) {
            try {
              var _inferenceModel$metad;
              const inferenceModels = await trainedModelsApiService.getTrainedModels(`${jobId}*`, {
                include: 'total_feature_importance'
              });
              const inferenceModel = inferenceModels.find(model => {
                var _model$metadata, _model$metadata$analy;
                return ((_model$metadata = model.metadata) === null || _model$metadata === void 0 ? void 0 : (_model$metadata$analy = _model$metadata.analytics_config) === null || _model$metadata$analy === void 0 ? void 0 : _model$metadata$analy.id) === jobId;
              });
              if (Array.isArray(inferenceModel === null || inferenceModel === void 0 ? void 0 : (_inferenceModel$metad = inferenceModel.metadata) === null || _inferenceModel$metad === void 0 ? void 0 : _inferenceModel$metad.total_feature_importance) === true) {
                var _inferenceModel$metad2;
                setTotalFeatureImportance(inferenceModel === null || inferenceModel === void 0 ? void 0 : (_inferenceModel$metad2 = inferenceModel.metadata) === null || _inferenceModel$metad2 === void 0 ? void 0 : _inferenceModel$metad2.total_feature_importance);
              }
            } catch (e) {
              toastNotificationService.displayErrorToast(e);
            }
          }
          try {
            var _await$getDataViewIdF;
            const destIndex = (0, _get_destination_index.getDestinationIndex)(jobConfigUpdate);
            const destDataViewId = (_await$getDataViewIdF = await getDataViewIdFromName(destIndex)) !== null && _await$getDataViewIdF !== void 0 ? _await$getDataViewIdF : destIndex;
            let fetchedDataView;
            try {
              fetchedDataView = await dataViews.get(destDataViewId);

              // Force refreshing the fields list here because a user directly coming
              // from the job creation wizard might land on the page without the
              // data view being fully initialized because it was created
              // before the analytics job populated the destination index.
              await dataViews.refreshFields(fetchedDataView);
            } catch (e) {
              fetchedDataView = undefined;
            }
            if (fetchedDataView === undefined) {
              var _await$getDataViewIdF2;
              setNeedsDestDataView(true);
              const sourceIndex = jobConfigUpdate.source.index[0];
              const sourceDataViewId = (_await$getDataViewIdF2 = await getDataViewIdFromName(sourceIndex)) !== null && _await$getDataViewIdF2 !== void 0 ? _await$getDataViewIdF2 : sourceIndex;
              try {
                fetchedDataView = await dataViews.get(sourceDataViewId);
              } catch (e) {
                fetchedDataView = undefined;
              }
            }
            if (fetchedDataView !== undefined) {
              await newJobCapsServiceAnalytics.initializeFromDataVIew(fetchedDataView);
              setJobConfig(analyticsConfigs.data_frame_analytics[0]);
              setDataView(fetchedDataView);
              setIsInitialized(true);
              setIsLoadingJobConfig(false);
            } else {
              setDataViewErrorMessage(_i18n.i18n.translate('xpack.ml.dataframe.analytics.results.dataViewMissingErrorMessage', {
                defaultMessage: 'To view this page, a Kibana data view is necessary for either the destination or source index of this analytics job.'
              }));
            }
          } catch (e) {
            setJobCapsServiceErrorMessage((0, _mlErrorUtils.extractErrorMessage)(e));
            setIsLoadingJobConfig(false);
          }
        }
      } catch (e) {
        setJobConfigErrorMessage((0, _mlErrorUtils.extractErrorMessage)(e));
        setIsLoadingJobConfig(false);
      }
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return {
    dataView,
    dataViewErrorMessage,
    isInitialized,
    isLoadingJobConfig,
    jobCapsServiceErrorMessage,
    jobConfig,
    jobConfigErrorMessage,
    jobStatus,
    needsDestDataView,
    totalFeatureImportance
  };
};
exports.useResultsViewConfig = useResultsViewConfig;