"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataSource = exports.DataSourceContextProvider = exports.DataSourceContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _queryString = require("query-string");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _index_utils = require("../../util/index_utils");
var _kibana = require("../kibana");
var _new_job_utils = require("../../jobs/new_job/utils/new_job_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/contexts/ml/data_source_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DataSourceContext = exports.DataSourceContext = /*#__PURE__*/_react.default.createContext({});

/**
 * Context provider that resolves current data view and the saved search from the URL state.
 *
 * @param children
 * @constructor
 */
const DataSourceContextProvider = ({
  children
}) => {
  const [value, setValue] = (0, _react.useState)();
  const [error, setError] = (0, _react.useState)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    services: {
      data: {
        dataViews
      },
      savedSearch: savedSearchService,
      uiSettings
    }
  } = (0, _kibana.useMlKibana)();
  const {
    index: dataViewId,
    savedSearchId
  } = (0, _queryString.parse)(location.search, {
    sort: false
  });
  const getDataViewAndSavedSearchCb = (0, _react.useCallback)(ssId => (0, _index_utils.getDataViewAndSavedSearchCallback)({
    savedSearchService,
    dataViewsService: dataViews
  })(ssId), [savedSearchService, dataViews]);

  /**
   * Resolve data view or saved search if exist in the URL.
   */
  const resolveDataSource = (0, _react.useCallback)(async () => {
    if (dataViewId === '') {
      throw new Error(_i18n.i18n.translate('xpack.ml.useResolver.errorIndexPatternIdEmptyString', {
        defaultMessage: 'dataViewId must not be empty string.'
      }));
    }
    let dataViewAndSavedSearch = {
      savedSearch: null,
      dataView: null
    };
    if (savedSearchId !== undefined) {
      dataViewAndSavedSearch = await getDataViewAndSavedSearchCb(savedSearchId);
    } else if (dataViewId !== undefined) {
      dataViewAndSavedSearch.dataView = await dataViews.get(dataViewId);
    }
    const {
      savedSearch,
      dataView
    } = dataViewAndSavedSearch;
    const {
      combinedQuery
    } = (0, _new_job_utils.createSearchItems)(uiSettings, dataView !== null ? dataView : undefined, savedSearch);
    return {
      combinedQuery,
      selectedDataView: dataView,
      selectedSavedSearch: savedSearch
    };
  }, [dataViewId, savedSearchId, uiSettings, dataViews, getDataViewAndSavedSearchCb]);
  (0, _react.useEffect)(() => {
    resolveDataSource().then(result => {
      setValue(result);
    }).catch(e => {
      setError(e);
    });
  }, [resolveDataSource]);
  if (!value && !error) return null;
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "error",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.dataSourceContext.errorTitle",
        defaultMessage: "Unable to fetch data view or saved Discover session",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 15
        }
      }, error.message),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(DataSourceContext.Provider, {
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 10
    }
  }, children);
};
exports.DataSourceContextProvider = DataSourceContextProvider;
const useDataSource = () => {
  return (0, _react.useContext)(DataSourceContext);
};
exports.useDataSource = useDataSource;