"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScopeExpression = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/rule_editor/scope_expression.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React component for rendering a rule scope expression.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getFilterListOptions(filterListIds) {
  return filterListIds.map(filterId => ({
    value: filterId,
    text: filterId
  }));
}
class ScopeExpression extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "openFilterList", () => {
      this.setState({
        isFilterListOpen: true
      });
    });
    (0, _defineProperty2.default)(this, "closeFilterList", () => {
      this.setState({
        isFilterListOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "onChangeFilterType", event => {
      const {
        fieldName,
        filterId,
        enabled,
        updateScope
      } = this.props;
      updateScope(fieldName, filterId, event.target.value, enabled);
    });
    (0, _defineProperty2.default)(this, "onChangeFilterId", event => {
      const {
        fieldName,
        filterType,
        enabled,
        updateScope
      } = this.props;
      updateScope(fieldName, event.target.value, filterType, enabled);
    });
    (0, _defineProperty2.default)(this, "onEnableChange", event => {
      const {
        fieldName,
        filterId,
        filterType,
        updateScope
      } = this.props;
      updateScope(fieldName, filterId, filterType, event.target.checked);
    });
    this.state = {
      isFilterListOpen: false
    };
  }
  renderFilterListPopover() {
    const {
      filterId,
      filterType,
      filterListIds
    } = this.props;
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.scopeExpression.scopeFilterTypePopoverTitle",
      defaultMessage: "Is",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "euiExpression",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      style: {
        maxWidth: 450
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: {
        width: 150
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      value: filterType,
      onChange: this.onChangeFilterType,
      "data-test-subj": "mlScopeFilterTypeSelect",
      options: [{
        value: _mlAnomalyUtils.ML_DETECTOR_RULE_FILTER_TYPE.INCLUDE,
        text: (0, _utils.filterTypeToText)(_mlAnomalyUtils.ML_DETECTOR_RULE_FILTER_TYPE.INCLUDE)
      }, {
        value: _mlAnomalyUtils.ML_DETECTOR_RULE_FILTER_TYPE.EXCLUDE,
        text: (0, _utils.filterTypeToText)(_mlAnomalyUtils.ML_DETECTOR_RULE_FILTER_TYPE.EXCLUDE)
      }],
      "aria-label": _i18n.i18n.translate('xpack.ml.ruleEditor.scopeExpression.filterTypeSelectAriaLabel', {
        defaultMessage: 'Filter type'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: {
        width: 300
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      value: filterId,
      onChange: this.onChangeFilterId,
      "data-test-subj": "mlScopeFilterIdSelect",
      options: getFilterListOptions(filterListIds),
      "aria-label": _i18n.i18n.translate('xpack.ml.ruleEditor.scopeExpression.filterListSelectAriaLabel', {
        defaultMessage: 'Filter list'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 15
      }
    })))));
  }
  render() {
    const {
      fieldName,
      filterId,
      filterType,
      enabled,
      filterListIds
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: `scope_cb_${fieldName}`,
      checked: enabled,
      onChange: this.onEnableChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.scopeExpression.scopeFieldWhenLabel",
        defaultMessage: "when",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 15
        }
      }),
      value: fieldName,
      isActive: false,
      css: {
        pointerEvents: 'none'
      },
      onClick: event => event.preventDefault(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 11
      }
    })), filterListIds !== undefined && filterListIds.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "operatorValuePopover",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
        description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.ruleEditor.scopeExpression.scopeFilterTypeButtonLabel",
          defaultMessage: "is {filterType}",
          values: {
            filterType: (0, _utils.filterTypeToText)(filterType)
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 167,
            columnNumber: 21
          }
        }),
        value: filterId || '',
        isActive: this.state.isFilterListOpen,
        onClick: this.openFilterList,
        "data-test-subj": "mlScopeExpressionFilterSelector",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 17
        }
      }),
      isOpen: this.state.isFilterListOpen,
      closePopover: this.closeFilterList,
      panelPaddingSize: "s",
      ownFocus: true,
      anchorPosition: "downLeft",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 13
      }
    }, this.renderFilterListPopover())));
  }
}
exports.ScopeExpression = ScopeExpression;
ScopeExpression.propTypes = {
  fieldName: _propTypes.default.string.isRequired,
  filterId: _propTypes.default.string,
  filterType: _propTypes.default.oneOf([_mlAnomalyUtils.ML_DETECTOR_RULE_FILTER_TYPE.INCLUDE, _mlAnomalyUtils.ML_DETECTOR_RULE_FILTER_TYPE.EXCLUDE]),
  enabled: _propTypes.default.bool.isRequired,
  filterListIds: _propTypes.default.array.isRequired,
  updateScope: _propTypes.default.func.isRequired
};