"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAnomalyDetectionRule = registerAnomalyDetectionRule;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _common = require("../../../common");
var _validators = require("../validators");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/alerting/anomaly_detection_rule/register_anomaly_detection_rule.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function registerAnomalyDetectionRule(triggersActionsUi, getStartServices, mlCapabilities) {
  const MlAlertTrigger = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./ml_anomaly_alert_trigger'))));
  triggersActionsUi.ruleTypeRegistry.register({
    id: _common.ML_ALERT_TYPES.ANOMALY_DETECTION,
    description: _i18n.i18n.translate('xpack.ml.alertTypes.anomalyDetection.description', {
      defaultMessage: 'Alert when anomaly detection jobs results match the condition.'
    }),
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return docLinks.links.ml.alertingRules;
    },
    ruleParamsExpression: props => {
      return /*#__PURE__*/_react.default.createElement(MlAlertTrigger, (0, _extends2.default)({}, props, {
        getStartServices: getStartServices,
        mlCapabilities: mlCapabilities,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 9
        }
      }));
    },
    validate: ruleParams => {
      var _ruleParams$jobSelect, _ruleParams$jobSelect2, _ruleParams$jobSelect3, _ruleParams$jobSelect4, _ruleParams$jobSelect5, _ruleParams$jobSelect6, _ruleParams$jobSelect7, _ruleParams$jobSelect8;
      const validationResult = {
        errors: {
          jobSelection: new Array(),
          severity: new Array(),
          resultType: new Array(),
          topNBuckets: new Array(),
          lookbackInterval: new Array()
        }
      };
      if (!((_ruleParams$jobSelect = ruleParams.jobSelection) !== null && _ruleParams$jobSelect !== void 0 && (_ruleParams$jobSelect2 = _ruleParams$jobSelect.jobIds) !== null && _ruleParams$jobSelect2 !== void 0 && _ruleParams$jobSelect2.length) && !((_ruleParams$jobSelect3 = ruleParams.jobSelection) !== null && _ruleParams$jobSelect3 !== void 0 && (_ruleParams$jobSelect4 = _ruleParams$jobSelect3.groupIds) !== null && _ruleParams$jobSelect4 !== void 0 && _ruleParams$jobSelect4.length)) {
        validationResult.errors.jobSelection.push(_i18n.i18n.translate('xpack.ml.alertTypes.anomalyDetection.jobSelection.errorMessage', {
          defaultMessage: 'Job selection is required'
        }));
      }

      // Since 7.13 we support single job selection only
      if (Array.isArray((_ruleParams$jobSelect5 = ruleParams.jobSelection) === null || _ruleParams$jobSelect5 === void 0 ? void 0 : _ruleParams$jobSelect5.groupIds) && ((_ruleParams$jobSelect6 = ruleParams.jobSelection) === null || _ruleParams$jobSelect6 === void 0 ? void 0 : _ruleParams$jobSelect6.groupIds.length) > 0 || Array.isArray((_ruleParams$jobSelect7 = ruleParams.jobSelection) === null || _ruleParams$jobSelect7 === void 0 ? void 0 : _ruleParams$jobSelect7.jobIds) && ((_ruleParams$jobSelect8 = ruleParams.jobSelection) === null || _ruleParams$jobSelect8 === void 0 ? void 0 : _ruleParams$jobSelect8.jobIds.length) > 1) {
        validationResult.errors.jobSelection.push(_i18n.i18n.translate('xpack.ml.alertTypes.anomalyDetection.singleJobSelection.errorMessage', {
          defaultMessage: 'Only one job per rule is allowed'
        }));
      }
      if (ruleParams.severity === undefined) {
        validationResult.errors.severity.push(_i18n.i18n.translate('xpack.ml.alertTypes.anomalyDetection.severity.errorMessage', {
          defaultMessage: 'Anomaly severity is required'
        }));
      }
      if (ruleParams.resultType === undefined) {
        validationResult.errors.resultType.push(_i18n.i18n.translate('xpack.ml.alertTypes.anomalyDetection.resultType.errorMessage', {
          defaultMessage: 'Result type is required'
        }));
      }
      if (!!ruleParams.lookbackInterval && (0, _validators.validateLookbackInterval)(ruleParams.lookbackInterval)) {
        validationResult.errors.lookbackInterval.push(_i18n.i18n.translate('xpack.ml.alertTypes.anomalyDetection.lookbackInterval.errorMessage', {
          defaultMessage: 'Lookback interval is invalid'
        }));
      }
      if (typeof ruleParams.topNBuckets === 'number' && (0, _validators.validateTopNBucket)(ruleParams.topNBuckets)) {
        validationResult.errors.topNBuckets.push(_i18n.i18n.translate('xpack.ml.alertTypes.anomalyDetection.topNBuckets.errorMessage', {
          defaultMessage: 'Number of buckets is invalid'
        }));
      }
      return validationResult;
    },
    requiresAppContext: false,
    defaultActionMessage: _i18n.i18n.translate('xpack.ml.alertTypes.anomalyDetection.defaultActionMessage', {
      defaultMessage: `['{{rule.name}}'] Elastic Stack Machine Learning Alert:
- Job IDs: '{{context.jobIds}}'
- Time: '{{context.timestampIso8601}}'
- Anomaly score: '{{context.score}}'

'{{context.message}}'

'{{#context.topInfluencers.length}}'
  Top influencers:
  '{{#context.topInfluencers}}'
    '{{influencer_field_name}}-' '{{influencer_field_value}}' ['{{score}}']
  '{{/context.topInfluencers}}'
'{{/context.topInfluencers.length}}'

'{{#context.topRecords.length}}'
  Top records:
  '{{#context.topRecords}}'
    '{{function}}' '{{field_name}}-' '{{by_field_value}}{{over_field_value}}{{partition_field_value}}' ['{{score}}']. Typical: '{{typical}}', Actual: '{{actual}}'.
  '{{/context.topRecords}}'
'{{/context.topRecords.length}}'

'{{! Replace kibanaBaseUrl if not configured in Kibana }}'
[Open in Anomaly Explorer]('{{{kibanaBaseUrl}}}{{{context.anomalyExplorerUrl}}'})
`
    })
  });
}