"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isBaseNLPModelItem = isBaseNLPModelItem;
exports.isBuiltInModel = void 0;
exports.isDFAModelItem = isDFAModelItem;
exports.isElasticModel = void 0;
exports.isExistingModel = isExistingModel;
exports.isModelDownloadItem = isModelDownloadItem;
exports.isNLPModelItem = isNLPModelItem;
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// compressed_definition and definition are mutually exclusive

/**
 * Get inference response from the ES endpoint
 */

// @ts-expect-error TrainedModelDeploymentStatsResponse missing properties from MlTrainedModelDeploymentStats

/**
 * Additional properties for all items in the Trained models table
 * */

/** Common properties for existing NLP models and NLP model download configs */

/** Model available for download */

/** Trained NLP model, i.e. pytorch model returned by the trained_models API */

function isBaseNLPModelItem(item) {
  return typeof item === 'object' && item !== null && 'type' in item && Array.isArray(item.type) && item.type.includes(_mlTrainedModelsUtils.TRAINED_MODEL_TYPE.PYTORCH);
}
function isNLPModelItem(item) {
  return isExistingModel(item) && item.model_type === _mlTrainedModelsUtils.TRAINED_MODEL_TYPE.PYTORCH;
}
const isElasticModel = item => item.tags.includes(_mlTrainedModelsUtils.ELASTIC_MODEL_TAG);

/** Any model returned by the trained_models API, e.g. lang_ident, elser, dfa model */

/** Trained DFA model */
exports.isElasticModel = isElasticModel;
function isExistingModel(item) {
  return typeof item === 'object' && item !== null && 'model_type' in item && 'create_time' in item && !!item.create_time;
}
function isDFAModelItem(item) {
  return isExistingModel(item) && item.model_type === _mlTrainedModelsUtils.TRAINED_MODEL_TYPE.TREE_ENSEMBLE;
}
function isModelDownloadItem(item) {
  var _item$type;
  return 'putModelConfig' in item && !!((_item$type = item.type) !== null && _item$type !== void 0 && _item$type.includes(_mlTrainedModelsUtils.TRAINED_MODEL_TYPE.PYTORCH));
}
const isBuiltInModel = item => item.tags.includes(_mlTrainedModelsUtils.BUILT_IN_MODEL_TAG);

/**
 * This type represents a union of different model entities:
 * - Any existing trained model returned by the API, e.g., lang_ident_model_1, DFA models, etc.
 * - Hosted model configurations available for download, e.g., ELSER or E5
 * - NLP models already downloaded into Elasticsearch
 * - DFA models
 */
exports.isBuiltInModel = isBuiltInModel;