"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSeverity = getSeverity;
var _anomaly_threshold = require("./anomaly_threshold");
var _anomaly_severity_types = require("./anomaly_severity_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a severity label (one of critical, major, minor, warning or unknown)
 * for the supplied normalized anomaly score (a value between 0 and 100).
 * @param normalizedScore - A normalized score between 0-100, which is based on the probability of the anomalousness of this record
 */
function getSeverity(normalizedScore) {
  if (normalizedScore >= _anomaly_threshold.ML_ANOMALY_THRESHOLD.CRITICAL) {
    return _anomaly_severity_types.ML_ANOMALY_SEVERITY_TYPES.critical;
  } else if (normalizedScore >= _anomaly_threshold.ML_ANOMALY_THRESHOLD.MAJOR) {
    return _anomaly_severity_types.ML_ANOMALY_SEVERITY_TYPES.major;
  } else if (normalizedScore >= _anomaly_threshold.ML_ANOMALY_THRESHOLD.MINOR) {
    return _anomaly_severity_types.ML_ANOMALY_SEVERITY_TYPES.minor;
  } else if (normalizedScore >= _anomaly_threshold.ML_ANOMALY_THRESHOLD.WARNING) {
    return _anomaly_severity_types.ML_ANOMALY_SEVERITY_TYPES.warning;
  } else if (normalizedScore >= _anomaly_threshold.ML_ANOMALY_THRESHOLD.LOW) {
    return _anomaly_severity_types.ML_ANOMALY_SEVERITY_TYPES.low;
  } else {
    return _anomaly_severity_types.ML_ANOMALY_SEVERITY_TYPES.unknown;
  }
}