"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexPatternMetadataRoutes = exports.getIndexPatternMetadataRoute = void 0;
var _zod = require("@kbn/zod");
var _tracedEsClient = require("@kbn/traced-es-client");
var _zodHelpers = require("@kbn/zod-helpers");
var _create_route = require("../create_route");
var _get_index_pattern_metadata = require("./get_index_pattern_metadata");
var _utils = require("../../lib/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getIndexPatternMetadataRoute = exports.getIndexPatternMetadataRoute = (0, _create_route.createRoute)({
  endpoint: 'GET /internal/metrics_experience/index_pattern_metadata/{indexPattern}',
  security: {
    authz: {
      requiredPrivileges: ['read']
    }
  },
  params: _zod.z.object({
    path: _zod.z.object({
      indexPattern: _zod.z.string()
    }),
    query: _zod.z.object({
      to: _zod.z.string().datetime().transform(_zodHelpers.isoToEpoch),
      from: _zod.z.string().datetime().transform(_zodHelpers.isoToEpoch)
    })
  }),
  handler: async ({
    context,
    params,
    logger
  }) => {
    const {
      elasticsearch,
      featureFlags
    } = await context.core;
    await (0, _utils.throwNotFoundIfMetricsExperienceDisabled)(featureFlags);
    const esClient = elasticsearch.client.asCurrentUser;
    const {
      indexPattern
    } = params.path;
    const {
      from,
      to
    } = params.query;
    const indexPatternMetadata = await (0, _get_index_pattern_metadata.getIndexPatternMetadata)({
      esClient: (0, _tracedEsClient.createTracedEsClient)({
        logger,
        client: esClient,
        plugin: 'metrics_experience'
      }),
      indexPattern,
      from,
      to
    });
    return {
      indexPatternMetadata
    };
  }
});
const indexPatternMetadataRoutes = exports.indexPatternMetadataRoutes = {
  ...getIndexPatternMetadataRoute
};