"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDimensions = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getDimensions = async ({
  esClient,
  dimensions,
  indices,
  from,
  to,
  logger
}) => {
  if (!dimensions || dimensions.length === 0) {
    return [];
  }
  try {
    const response = await esClient.search('get_dimensions', {
      index: indices.join(','),
      track_total_hits: false,
      size: 0,
      query: {
        bool: {
          filter: [...(0, _esQuery.dateRangeQuery)(from, to)]
        }
      },
      // Create aggregations for each dimension
      aggs: dimensions.reduce((acc, currDimension) => {
        acc[currDimension] = {
          terms: {
            field: currDimension,
            size: 20,
            order: {
              _key: 'asc'
            }
          }
        };
        return acc;
      }, {})
    });
    const aggregations = response.aggregations;
    const values = dimensions.flatMap(dimension => {
      var _agg$buckets$map, _agg$buckets;
      const agg = aggregations === null || aggregations === void 0 ? void 0 : aggregations[dimension];
      return (_agg$buckets$map = agg === null || agg === void 0 ? void 0 : (_agg$buckets = agg.buckets) === null || _agg$buckets === void 0 ? void 0 : _agg$buckets.map(bucket => {
        var _bucket$key;
        return {
          value: String((_bucket$key = bucket.key) !== null && _bucket$key !== void 0 ? _bucket$key : ''),
          field: dimension
        };
      })) !== null && _agg$buckets$map !== void 0 ? _agg$buckets$map : [];
    });
    return values;
  } catch (error) {
    logger.error('Error fetching dimension values:', error);
    return [];
  }
};
exports.getDimensions = getDimensions;