"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCompositeAggregations = exports.createAggregations = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _http_api = require("../../../../common/http_api");
var _constants = require("../../../../common/constants");
var _calculate_date_histogram_offset = require("./calculate_date_histogram_offset");
var _create_metrics_aggregations = require("./create_metrics_aggregations");
var _calculate_bucket_size = require("./calculate_bucket_size");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_LIMIT = 9;
const METRICSET_AGGS = {
  metricsets: {
    terms: {
      field: 'metricset.name'
    }
  }
};
const createMetricHistogramAggs = options => {
  const {
    intervalString
  } = (0, _calculate_bucket_size.calculateBucketSize)(options.timerange);
  return {
    histogram: {
      date_histogram: {
        field: _constants.TIMESTAMP,
        fixed_interval: intervalString,
        offset: options.alignDataToEnd ? (0, _calculate_date_histogram_offset.calculateDateHistogramOffset)(options.timerange) : '0s',
        extended_bounds: {
          min: options.timerange.from,
          max: options.timerange.to
        }
      },
      aggregations: (0, _create_metrics_aggregations.createMetricsAggregations)(options)
    }
  };
};
const getAfterKey = options => {
  if (!options.afterKey) {
    return null;
  }
  if (_http_api.afterKeyObjectRT.is(options.afterKey)) {
    return options.afterKey;
  } else {
    return {
      groupBy0: options.afterKey
    };
  }
};
const createCompositeAggregations = options => {
  var _options$limit;
  if (!Array.isArray(options.groupBy) || !options.groupBy.length) {
    throw _boom.default.badRequest('groupBy must be informed.');
  }
  if (!options.includeTimeseries && !!options.metrics.find(p => p.id === 'logRate')) {
    throw _boom.default.badRequest('logRate metric is not supported without time series');
  }
  const after = getAfterKey(options);
  return {
    groupings: {
      composite: {
        size: (_options$limit = options.limit) !== null && _options$limit !== void 0 ? _options$limit : DEFAULT_LIMIT,
        sources: options.groupBy.map((field, index) => ({
          [`groupBy${index}`]: {
            terms: {
              field
            }
          }
        })),
        ...(after ? {
          after
        } : {})
      },
      aggs: {
        ...(options.includeTimeseries ? createMetricHistogramAggs(options) : (0, _create_metrics_aggregations.createMetricsAggregations)(options)),
        ...METRICSET_AGGS
      }
    }
  };
};
exports.createCompositeAggregations = createCompositeAggregations;
const createAggregations = options => {
  return {
    ...createMetricHistogramAggs(options),
    ...METRICSET_AGGS
  };
};
exports.createAggregations = createAggregations;