"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.symbolizeAsSchema = exports.symbolizeAsOptions = exports.sizeStaticOptions = exports.sizeSchema = exports.sizeDynamicOptions = exports.orientationStaticOptions = exports.orientationSchema = exports.orientationDynamicOptions = exports.lineWidthSchema = exports.labelSizeSchema = exports.iconStop = exports.iconStaticOptions = exports.iconSizeSchema = exports.iconSchema = exports.iconDynamicOptions = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../../../common/constants");
var _vector_style_schemas = require("./vector_style_schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const symbolizeAsOptions = exports.symbolizeAsOptions = _configSchema.schema.object({
  value: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.SYMBOLIZE_AS_TYPES.CIRCLE), _configSchema.schema.literal(_constants.SYMBOLIZE_AS_TYPES.ICON)]))
});
const symbolizeAsSchema = exports.symbolizeAsSchema = _configSchema.schema.object({
  options: _configSchema.schema.object({
    value: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.SYMBOLIZE_AS_TYPES.CIRCLE), _configSchema.schema.literal(_constants.SYMBOLIZE_AS_TYPES.ICON)]))
  })
}, {
  defaultValue: {
    options: {
      value: _constants.SYMBOLIZE_AS_TYPES.CIRCLE
    }
  },
  meta: {
    description: 'Configure to symbolize Point features as Circle markers or Icons'
  }
});
const iconSource = _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.ICON_SOURCE.CUSTOM), _configSchema.schema.literal(_constants.ICON_SOURCE.MAKI)]));
const iconStop = exports.iconStop = _configSchema.schema.object({
  stop: _configSchema.schema.nullable(_configSchema.schema.string()),
  icon: _configSchema.schema.string(),
  iconSource
});
const iconDynamicOptions = exports.iconDynamicOptions = _configSchema.schema.object({
  iconPaletteId: _configSchema.schema.nullable(_configSchema.schema.string()),
  customIconStops: _configSchema.schema.maybe(_configSchema.schema.arrayOf(iconStop)),
  useCustomIconMap: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  field: _configSchema.schema.maybe(_vector_style_schemas.styleField),
  fieldMetaOptions: _vector_style_schemas.fieldMetaOptions
});
const iconStaticOptions = exports.iconStaticOptions = _configSchema.schema.object({
  value: _configSchema.schema.string({
    meta: {
      description: 'icon id'
    }
  }),
  label: _configSchema.schema.maybe(_configSchema.schema.string()),
  svg: _configSchema.schema.maybe(_configSchema.schema.string()),
  iconSource: _configSchema.schema.maybe(iconSource)
});
const iconSchema = exports.iconSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  type: _configSchema.schema.literal(_constants.STYLE_TYPE.STATIC),
  options: iconStaticOptions
}), _configSchema.schema.object({
  type: _configSchema.schema.literal(_constants.STYLE_TYPE.DYNAMIC),
  options: iconDynamicOptions
})], {
  defaultValue: {
    type: _constants.STYLE_TYPE.STATIC,
    options: {
      value: _constants.DEFAULT_ICON
    }
  },
  meta: {
    description: 'Configure to set Point feature icon'
  }
});
const orientationDynamicOptions = exports.orientationDynamicOptions = _configSchema.schema.object({
  field: _configSchema.schema.maybe(_vector_style_schemas.styleField),
  fieldMetaOptions: _vector_style_schemas.fieldMetaOptions
});
const orientationStaticOptions = exports.orientationStaticOptions = _configSchema.schema.object({
  orientation: _configSchema.schema.number()
});
const orientationSchema = exports.orientationSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  type: _configSchema.schema.literal(_constants.STYLE_TYPE.STATIC),
  options: orientationStaticOptions
}), _configSchema.schema.object({
  type: _configSchema.schema.literal(_constants.STYLE_TYPE.DYNAMIC),
  options: orientationDynamicOptions
})], {
  defaultValue: {
    type: _constants.STYLE_TYPE.STATIC,
    options: {
      orientation: 0
    }
  },
  meta: {
    description: 'Configure to rotate the icon clockwise. Ignored when Point features are symbolized as circle markers'
  }
});
const sizeDynamicOptions = exports.sizeDynamicOptions = _configSchema.schema.object({
  minSize: _configSchema.schema.number(),
  maxSize: _configSchema.schema.number(),
  field: _configSchema.schema.maybe(_vector_style_schemas.styleField),
  fieldMetaOptions: _vector_style_schemas.fieldMetaOptions,
  invert: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const sizeStaticOptions = exports.sizeStaticOptions = _configSchema.schema.object({
  size: _configSchema.schema.number()
});
const sizeStaticSchema = _configSchema.schema.object({
  type: _configSchema.schema.literal(_constants.STYLE_TYPE.STATIC),
  options: sizeStaticOptions
});
const sizeDynamiceSchema = _configSchema.schema.object({
  type: _configSchema.schema.literal(_constants.STYLE_TYPE.DYNAMIC),
  options: sizeDynamicOptions
});
const sizeSchema = exports.sizeSchema = _configSchema.schema.oneOf([sizeStaticSchema, sizeDynamiceSchema]);
const lineWidthSchema = exports.lineWidthSchema = _configSchema.schema.oneOf([sizeStaticSchema, sizeDynamiceSchema], {
  defaultValue: {
    type: _constants.STYLE_TYPE.STATIC,
    options: {
      size: 1
    }
  },
  meta: {
    description: 'Configure to set feature border width'
  }
});
const iconSizeSchema = exports.iconSizeSchema = _configSchema.schema.oneOf([sizeStaticSchema, sizeDynamiceSchema], {
  defaultValue: {
    type: _constants.STYLE_TYPE.STATIC,
    options: {
      size: 6
    }
  },
  meta: {
    description: 'Configure to set Point feature radius size in pixels'
  }
});
const labelSizeSchema = exports.labelSizeSchema = _configSchema.schema.oneOf([sizeStaticSchema, sizeDynamiceSchema], {
  defaultValue: {
    type: _constants.STYLE_TYPE.STATIC,
    options: {
      size: 14
    }
  },
  meta: {
    description: 'Configure to set label text size'
  }
});