"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualizeGeoFieldAction = void 0;
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/ui-actions-plugin/public");
var _kibana_services = require("../kibana_services");
var _constants = require("../../common/constants");
var _get_maps_link = require("./get_maps_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const visualizeGeoFieldAction = exports.visualizeGeoFieldAction = (0, _public.createAction)({
  id: _public.ACTION_VISUALIZE_GEO_FIELD,
  type: _public.ACTION_VISUALIZE_GEO_FIELD,
  getDisplayName: () => _i18n.i18n.translate('xpack.maps.discover.visualizeFieldLabel', {
    defaultMessage: 'Visualize in Maps'
  }),
  isCompatible: async context => {
    return Boolean(!!(0, _kibana_services.getVisualizeCapabilities)().show && context.dataViewSpec && context.fieldName);
  },
  getHref: async context => {
    const {
      app,
      path
    } = await (0, _get_maps_link.getMapsLink)(context);
    return (0, _kibana_services.getCore)().application.getUrlForApp(app, {
      path,
      absolute: false
    });
  },
  execute: async context => {
    const {
      app,
      path,
      state
    } = await (0, _get_maps_link.getMapsLink)(context);
    const usageCollection = (0, _kibana_services.getUsageCollection)();
    usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiCounter(_constants.APP_ID, _analytics.METRIC_TYPE.CLICK, `create_maps_vis_${context.originatingApp ? context.originatingApp : 'unknownOriginatingApp'}`);
    (0, _kibana_services.getCore)().application.navigateToApp(app, {
      path,
      state
    });
  }
});