"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInitialLayersFromUrlParam = getInitialLayersFromUrlParam;
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _i18n = require("@kbn/i18n");
var _kibana_services = require("../../../kibana_services");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isObj(v) {
  return typeof v === 'object' && v !== null;
}
function parseLayerDescriptors(mapInitLayers) {
  const raw = _rison.default.decodeArray(mapInitLayers);
  return raw.flatMap((desc, i) => {
    if (isObj(desc) && typeof desc.id === 'string') {
      return desc;
    }

    // we shouldn't end up here, but if we do it's likely only in testing or local dev so a console error is suitable
    // eslint-disable-next-line no-console
    console.error(`item ${i} in mapInitLayers is not a valid LayerDescriptor and was ignored`);
    return [];
  });
}
function getInitialLayersFromUrlParam() {
  const locationSplit = window.location.href.split('?');
  if (locationSplit.length <= 1) {
    return [];
  }
  const mapAppParams = new URLSearchParams(locationSplit[1]);
  let mapInitLayers = mapAppParams.get(_constants.INITIAL_LAYERS_KEY);
  if (!mapInitLayers) {
    return [];
  }
  try {
    // strip # from the end of the param
    if (mapInitLayers.endsWith('#')) {
      mapInitLayers = mapInitLayers.slice(0, -1);
    }
    return parseLayerDescriptors(mapInitLayers);
  } catch (e) {
    (0, _kibana_services.getToasts)().addWarning({
      title: _i18n.i18n.translate('xpack.maps.initialLayers.unableToParseTitle', {
        defaultMessage: `Initial layers not added to map`
      }),
      text: _i18n.i18n.translate('xpack.maps.initialLayers.unableToParseMessage', {
        defaultMessage: `Unable to parse contents of 'initialLayers' parameter. Error: {errorMsg}`,
        values: {
          errorMsg: e.message
        }
      })
    });
    return [];
  }
}