"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuggestionsLazy = getSuggestionsLazy;
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let emsFileLayers;
let getSuggestionsActual;
let promise;

/**
 * Avoid loading file layers during plugin setup
 * Instead, load file layers when getSuggestions is called
 * Since getSuggestions is sync, the trade off is that
 * getSuggestions will return no suggestions until file layers load
 */
function getSuggestionsLazy(suggestionRequest) {
  if (!promise) {
    promise = new Promise(resolve => {
      Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./suggestions'))), Promise.resolve().then(() => _interopRequireWildcard(require('../../util')))]).then(async ([{
        getSuggestions
      }, {
        getEmsFileLayers
      }]) => {
        getSuggestionsActual = getSuggestions;
        try {
          emsFileLayers = await getEmsFileLayers();
        } catch (error) {
          // eslint-disable-next-line no-console
          console.warn(`Lens region map is unable to access administrative boundaries from Elastic Maps Service (EMS). To avoid unnecessary EMS requests, set 'map.includeElasticMapsService: false' in 'kibana.yml'.`);
        }
        resolve();
      }).catch(resolve);
    });
    return [];
  }
  return emsFileLayers && getSuggestionsActual ? getSuggestionsActual(suggestionRequest, emsFileLayers) : [];
}