"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTileMapFn = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createTileMapFn = () => ({
  name: 'tilemap',
  type: 'render',
  help: _i18n.i18n.translate('xpack.maps.tileMap.function.help', {
    defaultMessage: 'Tilemap visualization'
  }),
  args: {
    visConfig: {
      types: ['string'],
      default: '"{}"',
      help: ''
    }
  },
  async fn(input, args) {
    const query = input.query;
    return {
      type: 'render',
      as: _types.TILE_MAP_RENDER,
      value: {
        visType: _types.TILE_MAP_VIS_TYPE,
        visConfig: JSON.parse(args.visConfig),
        filters: input.filters,
        query: Array.isArray(query) ? query[0] : query,
        timeRange: input.timeRange
      }
    };
  }
});
exports.createTileMapFn = createTileMapFn;