"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformRequest = transformRequest;
var _coreHttpCommon = require("@kbn/core-http-common");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This URL could be used from inside a Worker which may have a different base
 * URL. This function takes a string that may be a path and converts it to an
 * absolute URL.
 */
function prepareAbsoluteUrl(pathOrUrl) {
  pathOrUrl = pathOrUrl.trim();
  if (pathOrUrl.startsWith('/')) {
    return new URL(pathOrUrl, window.location.origin).toString();
  }
  return pathOrUrl;
}

/**
 * @param pathOrUrl - Assumed to be a full URL or a path starting with "/"
 * @param resourceType - Indicator of what type of resource is being requested
 */
function transformRequest(pathOrUrl, resourceType) {
  const url = prepareAbsoluteUrl(pathOrUrl);
  if (resourceType === 'Glyphs' && url.includes(_constants.FONTS_API_PATH)) {
    return {
      url,
      method: 'GET',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1',
        [_coreHttpCommon.X_ELASTIC_INTERNAL_ORIGIN_REQUEST]: 'kibana'
      }
    };
  }
  if (resourceType === 'Tile' && url.includes(_constants.MVT_GETTILE_API_PATH)) {
    return {
      url,
      method: 'GET',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1',
        [_coreHttpCommon.X_ELASTIC_INTERNAL_ORIGIN_REQUEST]: 'kibana'
      }
    };
  }
  if (resourceType === 'Tile' && url.includes(_constants.MVT_GETGRIDTILE_API_PATH)) {
    return {
      url,
      method: 'GET',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1',
        [_coreHttpCommon.X_ELASTIC_INTERNAL_ORIGIN_REQUEST]: 'kibana'
      }
    };
  }
  return {
    url
  };
}