"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TooltipSelector = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _add_tooltip_field_popover = require("./add_tooltip_field_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/components/tooltip_selector/tooltip_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO import reorder from EUI once its exposed as service
// https://github.com/elastic/eui/issues/2372
const reorder = (list, startIndex, endIndex) => {
  const result = Array.from(list);
  const [removed] = result.splice(startIndex, 1);
  result.splice(endIndex, 0, removed);
  return result;
};
async function getFieldProps(field) {
  return {
    label: await field.getLabel(),
    type: await field.getDataType(),
    name: field.getName()
  };
}
class TooltipSelector extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_isMounted", void 0);
    (0, _defineProperty2.default)(this, "_previousFields", void 0);
    (0, _defineProperty2.default)(this, "_previousSelectedTooltips", void 0);
    (0, _defineProperty2.default)(this, "state", {
      fieldProps: [],
      selectedFieldProps: []
    });
    (0, _defineProperty2.default)(this, "_getPropertyLabel", propertyName => {
      if (!this.state.fieldProps.length) {
        return propertyName;
      }
      const prop = this.state.fieldProps.find(field => {
        return field.name === propertyName;
      });

      // @ts-expect-error 4.3.5 upgrade
      return prop ? prop.label : propertyName;
    });
    (0, _defineProperty2.default)(this, "_onAdd", properties => {
      if (!this.props.tooltipFields) {
        this.props.onChange([...properties]);
      } else {
        const existingProperties = this._getTooltipFieldNames();
        this.props.onChange([...existingProperties, ...properties]);
      }
    });
    (0, _defineProperty2.default)(this, "_removeProperty", index => {
      if (!this.props.tooltipFields) {
        this.props.onChange([]);
      } else {
        const tooltipProperties = this._getTooltipFieldNames();
        tooltipProperties.splice(index, 1);
        this.props.onChange(tooltipProperties);
      }
    });
    (0, _defineProperty2.default)(this, "_onDragEnd", ({
      source,
      destination
    }) => {
      // Dragging item out of EuiDroppable results in destination of null
      if (!destination) {
        return;
      }
      this.props.onChange(reorder(this._getTooltipFieldNames(), source.index, destination.index));
    });
    this._isMounted = false;
    this._previousFields = null;
    this._previousSelectedTooltips = null;
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadFieldProps();
    this._loadTooltipFieldProps();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  componentDidUpdate() {
    this._loadTooltipFieldProps();
    this._loadFieldProps();
  }
  async _loadTooltipFieldProps() {
    if (!this.props.tooltipFields || this.props.tooltipFields === this._previousSelectedTooltips) {
      return;
    }
    this._previousSelectedTooltips = this.props.tooltipFields;
    const promises = this.props.tooltipFields.map(getFieldProps);
    const selectedFieldProps = await Promise.all(promises);
    if (this._isMounted) {
      this.setState({
        selectedFieldProps
      });
    }
  }
  async _loadFieldProps() {
    if (!this.props.fields || this.props.fields === this._previousFields) {
      return;
    }
    this._previousFields = this.props.fields;
    const promises = this.props.fields.map(getFieldProps);
    const fieldProps = await Promise.all(promises);
    if (this._isMounted) {
      this.setState({
        fieldProps
      });
    }
  }
  _getTooltipFieldNames() {
    return this.props.tooltipFields ? this.props.tooltipFields.map(field => field.getName()) : [];
  }
  _renderProperties() {
    if (!this.state.selectedFieldProps.length) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        textAlign: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 164,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.tooltipSelector.emptyState.description",
        defaultMessage: "Add a tooltip field to create filters from field values.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 15
        }
      }))));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
      onDragEnd: this._onDragEnd,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
      droppableId: "mapLayerTOC",
      spacing: "none",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 9
      }
    }, (droppableProvided, snapshot) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 13
      }
    }, this.state.selectedFieldProps.map((field, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
      spacing: "none",
      key: field.name,
      index: idx,
      draggableId: field.name,
      customDragHandle: true,
      disableInteractiveElementBlocking: true // Allows button to be drag handle
      ,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 17
      }
    }, (provided, state) => /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('mapTooltipSelector__propertyRow', {
        'mapTooltipSelector__propertyRow-isDragging': state.isDragging,
        'mapTooltipSelector__propertyRow-isDraggingOver': snapshot.isDraggingOver
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      className: "mapTooltipSelector__propertyContent",
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 23
      }
    }, this._getPropertyLabel(field.name)), /*#__PURE__*/_react.default.createElement("div", {
      className: "mapTooltipSelector__propertyIcons",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "trash",
      color: "danger",
      onClick: this._removeProperty.bind(null, idx),
      title: _i18n.i18n.translate('xpack.maps.tooltipSelector.trashButtonTitle', {
        defaultMessage: 'Remove property'
      }),
      "aria-label": _i18n.i18n.translate('xpack.maps.tooltipSelector.trashButtonAriaLabel', {
        defaultMessage: 'Remove property'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 25
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
      className: "mapTooltipSelector__grab",
      iconType: "grab",
      color: "text",
      title: _i18n.i18n.translate('xpack.maps.tooltipSelector.grabButtonTitle', {
        defaultMessage: 'Reorder property'
      }),
      "aria-label": _i18n.i18n.translate('xpack.maps.tooltipSelector.grabButtonAriaLabel', {
        defaultMessage: 'Reorder property'
      })
    }, provided.dragHandleProps, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 25
      }
    })))))))));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 7
      }
    }, this._renderProperties(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
      textAlign: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_add_tooltip_field_popover.AddTooltipFieldPopover, {
      onAdd: this._onAdd,
      fields: this.state.fieldProps,
      selectedFields: this.state.selectedFieldProps,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 11
      }
    })));
  }
}
exports.TooltipSelector = TooltipSelector;