"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExecutionContextId = getExecutionContextId;
exports.mergeExecutionContext = mergeExecutionContext;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mergeExecutionContext(mergeContext, context = {}) {
  if (isMapContext(context)) {
    return {
      ...context,
      ...mergeContext
    };
  }
  if (context.child !== undefined) {
    return {
      ...context,
      child: {
        ...mergeExecutionContext(mergeContext, context.child)
      }
    };
  }
  return context;
}
function getExecutionContextId(context = {}) {
  if (isMapContext(context)) {
    return context.id;
  }
  if (context.child !== undefined) {
    return getExecutionContextId(context.child);
  }
  return undefined;
}
function isMapContext(context) {
  return context.name === _constants.APP_ID;
}