"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToGeoJson = convertToGeoJson;
var _wellknown = require("wellknown");
var _constants = require("../../../../common/constants");
var _esql_utils = require("./esql_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-ignore

function convertToGeoJson(resp) {
  const geometryColumnIndex = resp.columns.findIndex(_esql_utils.isGeometryColumn);
  if (geometryColumnIndex === -1) {
    return _constants.EMPTY_FEATURE_COLLECTION;
  }
  const features = [];
  for (let i = 0; i < resp.values.length; i++) {
    const hit = resp.values[i];
    const wkt = hit[geometryColumnIndex];
    if (!wkt) {
      continue;
    }
    try {
      const geometry = (0, _wellknown.parse)(wkt);
      const properties = {};
      for (let j = 0; j < hit.length; j++) {
        // do not store geometry in properties
        if (j === geometryColumnIndex) {
          continue;
        }
        properties[resp.columns[j].name] = hit[j];
      }
      features.push({
        type: 'Feature',
        geometry,
        properties
      });
    } catch (parseError) {
      // TODO surface parse error in some kind of warning
    }
  }
  return {
    type: 'FeatureCollection',
    features
  };
}