"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourceTitle = exports.ESPewPewSource = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _bbox = _interopRequireDefault(require("@turf/bbox"));
var _helpers = require("@turf/helpers");
var _esQuery = require("@kbn/es-query");
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _update_source_editor = require("./update_source_editor");
var _constants = require("../../../../common/constants");
var _i18n_getters = require("../../../../common/i18n_getters");
var _convert_to_lines = require("./convert_to_lines");
var _es_agg_source = require("../es_agg_source");
var _elasticsearch_util = require("../../../../common/elasticsearch_util");
var _data_request = require("../../util/data_request");
var _execution_context_utils = require("../execution_context_utils");
var _valid_string_config = require("../../util/valid_string_config");
var _vector_source = require("../vector_source");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/es_pew_pew_source/es_pew_pew_source.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MAX_GEOTILE_LEVEL = 29;
const sourceTitle = exports.sourceTitle = _i18n.i18n.translate('xpack.maps.source.pewPewTitle', {
  defaultMessage: 'Point to point'
});
class ESPewPewSource extends _es_agg_source.AbstractESAggSource {
  static createDescriptor(descriptor) {
    const normalizedDescriptor = _es_agg_source.AbstractESAggSource.createDescriptor(descriptor);
    if (!(0, _valid_string_config.isValidStringConfig)(descriptor.sourceGeoField)) {
      throw new Error('Cannot create ESPewPewSourceDescriptor, sourceGeoField is not provided');
    }
    if (!(0, _valid_string_config.isValidStringConfig)(descriptor.destGeoField)) {
      throw new Error('Cannot create ESPewPewSourceDescriptor, destGeoField is not provided');
    }
    return {
      ...normalizedDescriptor,
      type: _constants.SOURCE_TYPES.ES_PEW_PEW,
      sourceGeoField: descriptor.sourceGeoField,
      destGeoField: descriptor.destGeoField
    };
  }
  constructor(descriptor) {
    const normalizedDescriptor = ESPewPewSource.createDescriptor(descriptor);
    super(normalizedDescriptor);
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    this._descriptor = normalizedDescriptor;
  }
  getBucketsName() {
    return _i18n.i18n.translate('xpack.maps.source.pewPew.bucketsName', {
      defaultMessage: 'paths'
    });
  }
  renderSourceSettingsEditor({
    onChange
  }) {
    return /*#__PURE__*/_react.default.createElement(_update_source_editor.UpdateSourceEditor, {
      bucketsName: this.getBucketsName(),
      indexPatternId: this.getIndexPatternId(),
      onChange: onChange,
      metrics: this._descriptor.metrics,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 7
      }
    });
  }
  isFilterByMapBounds() {
    return true;
  }
  supportsJoins() {
    return false;
  }
  getSyncMeta(dataFilters) {
    return {
      ...super.getSyncMeta(dataFilters),
      geogridPrecision: this.getGeoGridPrecision(dataFilters.zoom)
    };
  }
  isGeoGridPrecisionAware() {
    return true;
  }
  async getSupportedShapeTypes() {
    return [_constants.VECTOR_SHAPE_TYPE.LINE];
  }
  async getImmutableProperties() {
    return [{
      label: (0, _i18n_getters.getDataSourceLabel)(),
      value: sourceTitle
    }, {
      label: (0, _i18n_getters.getDataViewLabel)(),
      value: await this.getDisplayName()
    }, {
      label: _i18n.i18n.translate('xpack.maps.source.pewPew.sourceGeoFieldLabel', {
        defaultMessage: 'Source'
      }),
      value: this._descriptor.sourceGeoField
    }, {
      label: _i18n.i18n.translate('xpack.maps.source.pewPew.destGeoFieldLabel', {
        defaultMessage: 'Destination'
      }),
      value: this._descriptor.destGeoField
    }];
  }
  getGeoGridPrecision(zoom) {
    const targetGeotileLevel = Math.ceil(zoom) + 2;
    return Math.min(targetGeotileLevel, MAX_GEOTILE_LEVEL);
  }
  async getGeoJsonWithMeta(layerName, requestMeta, registerCancelCallback, isRequestStillActive, inspectorAdapters) {
    const indexPattern = await this.getIndexPattern();
    const searchSource = await this.makeSearchSource(requestMeta, 0);
    searchSource.setField('trackTotalHits', false);
    searchSource.setField('aggs', {
      destSplit: {
        terms: {
          script: {
            source: `doc['${this._descriptor.destGeoField}'].value.toString()`,
            lang: 'painless'
          },
          order: {
            _count: 'desc'
          },
          size: 100
        },
        aggs: {
          sourceGrid: {
            geotile_grid: {
              field: this._descriptor.sourceGeoField,
              precision: this.getGeoGridPrecision(requestMeta.zoom),
              size: 500
            },
            aggs: {
              sourceCentroid: {
                geo_centroid: {
                  field: this._descriptor.sourceGeoField
                }
              },
              ...this.getValueAggsDsl(indexPattern)
            }
          }
        }
      }
    });

    // pewpew source is often used with security solution index-pattern
    // Some underlying indices may not contain geo fields
    // Filter out documents without geo fields to avoid shard failures for those indices
    searchSource.setField('filter', [...searchSource.getField('filter'),
    // destGeoField exists ensured by buffer filter
    // so only need additional check for sourceGeoField
    (0, _esQuery.buildExistsFilter)({
      name: this._descriptor.sourceGeoField,
      type: 'geo_point'
    }, indexPattern)]);
    const warnings = [];
    const esResponse = await this._runEsQuery({
      requestId: this.getId(),
      requestName: (0, _vector_source.getLayerFeaturesRequestName)(layerName),
      searchSource,
      registerCancelCallback,
      searchSessionId: requestMeta.searchSessionId,
      executionContext: (0, _execution_context_utils.mergeExecutionContext)({
        description: 'es_pew_pew_source:connections'
      }, requestMeta.executionContext),
      requestsAdapter: inspectorAdapters.requests,
      onWarning: warning => {
        warnings.push(warning);
      }
    });
    const {
      featureCollection
    } = (0, _convert_to_lines.convertToLines)(esResponse);
    return {
      data: featureCollection,
      meta: {
        areResultsTrimmed: false,
        warnings
      }
    };
  }
  getGeoFieldName() {
    return this._descriptor.destGeoField;
  }
  async getBoundsForFilters(boundsFilters, registerCancelCallback) {
    const searchSource = await this.makeSearchSource(boundsFilters, 0);
    searchSource.setField('trackTotalHits', false);
    searchSource.setField('aggs', {
      destFitToBounds: {
        geo_bounds: {
          field: this._descriptor.destGeoField
        }
      },
      sourceFitToBounds: {
        geo_bounds: {
          field: this._descriptor.sourceGeoField
        }
      }
    });
    const corners = [];
    try {
      var _esResp$aggregations, _esResp$aggregations2;
      const abortController = new AbortController();
      registerCancelCallback(() => abortController.abort());
      const {
        rawResponse: esResp
      } = await (0, _rxjs.lastValueFrom)(searchSource.fetch$({
        abortSignal: abortController.signal,
        legacyHitsTotal: false,
        executionContext: (0, _execution_context_utils.mergeExecutionContext)({
          description: 'es_pew_pew_source:bounds'
        }, boundsFilters.executionContext)
      }));
      const destBounds = ((_esResp$aggregations = esResp.aggregations) === null || _esResp$aggregations === void 0 ? void 0 : _esResp$aggregations.destFitToBounds).bounds;
      if (destBounds) {
        corners.push([destBounds.top_left.lon, destBounds.top_left.lat]);
        corners.push([destBounds.bottom_right.lon, destBounds.bottom_right.lat]);
      }
      const sourceBounds = ((_esResp$aggregations2 = esResp.aggregations) === null || _esResp$aggregations2 === void 0 ? void 0 : _esResp$aggregations2.sourceFitToBounds).bounds;
      if (sourceBounds) {
        corners.push([sourceBounds.top_left.lon, sourceBounds.top_left.lat]);
        corners.push([sourceBounds.bottom_right.lon, sourceBounds.bottom_right.lat]);
      }
    } catch (error) {
      if (error.name === 'AbortError') {
        throw new _data_request.DataRequestAbortError();
      }
      return null;
    }
    if (corners.length === 0) {
      return null;
    }
    return (0, _elasticsearch_util.turfBboxToBounds)((0, _bbox.default)((0, _helpers.multiPoint)(corners)));
  }
  hasTooltipProperties() {
    return true;
  }
}
exports.ESPewPewSource = ESPewPewSource;