"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopTermPercentageField = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _tooltip_property = require("../../tooltips/tooltip_property");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TopTermPercentageField {
  constructor(topTermAggField) {
    (0, _defineProperty2.default)(this, "_topTermAggField", void 0);
    this._topTermAggField = topTermAggField;
  }
  supportsFieldMetaFromEs() {
    return false;
  }
  supportsFieldMetaFromLocalData() {
    if (this.getSource().isMvt()) {
      // Elasticsearch vector tile search API does not support top term metric so meta tile does not contain any values
      return false;
    } else {
      // field meta can be extracted from local data when field is geojson source
      return true;
    }
  }
  getSource() {
    return this._topTermAggField.getSource();
  }
  getMbFieldName() {
    return this.getName();
  }
  getOrigin() {
    return this._topTermAggField.getOrigin();
  }
  getName() {
    return `${this._topTermAggField.getName()}${_constants.TOP_TERM_PERCENTAGE_SUFFIX}`;
  }
  getRootName() {
    // top term percentage is a derived value so it has no root field
    return '';
  }
  async getLabel() {
    const baseLabel = await this._topTermAggField.getLabel();
    return `${baseLabel}%`;
  }
  isValid() {
    return this._topTermAggField.isValid();
  }
  async getDataType() {
    return 'number';
  }
  async createTooltipProperty(value) {
    return new _tooltip_property.TooltipProperty(this.getName(), await this.getLabel(), value);
  }
  getValueAggDsl() {
    return null;
  }
  getBucketCount() {
    return 0;
  }
  isCount() {
    return false;
  }
  async getExtendedStatsFieldMetaRequest() {
    return null;
  }
  async getPercentilesFieldMetaRequest(percentiles) {
    return null;
  }
  async getCategoricalFieldMetaRequest() {
    return null;
  }
  canValueBeFormatted() {
    return false;
  }
  isEqual(field) {
    return field.getName() === this.getName();
  }
  pluckRangeFromTileMetaFeature(metaFeature) {
    return null;
  }
  getMask() {
    return undefined;
  }
}
exports.TopTermPercentageField = TopTermPercentageField;