"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useVisibilityState = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useVisibilityState = initialState => {
  const [isVisible, setIsVisible] = (0, _react.useState)(initialState);
  const hide = (0, _react.useCallback)(() => setIsVisible(false), []);
  const show = (0, _react.useCallback)(() => setIsVisible(true), []);
  const toggle = (0, _react.useCallback)(() => setIsVisible(state => !state), []);
  return (0, _react.useMemo)(() => ({
    hide,
    isVisible,
    show,
    toggle
  }), [hide, isVisible, show, toggle]);
};
exports.useVisibilityState = useVisibilityState;