"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createListIndexRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _api = require("@kbn/securitysolution-lists-common/api");
var _utils = require("../utils");
var _2 = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createListIndexRoute = router => {
  router.versioned.post({
    access: 'public',
    path: _securitysolutionListConstants.LIST_INDEX,
    security: {
      authz: {
        requiredPrivileges: ['lists-all']
      }
    }
  }).addVersion({
    validate: false,
    version: '2023-10-31'
  }, async (context, _, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const lists = await (0, _2.getInternalListClient)(context);
      const listDataStreamExists = await lists.getListDataStreamExists();
      const listItemDataStreamExists = await lists.getListItemDataStreamExists();
      const templateListExists = await lists.getListTemplateExists();
      const templateListItemsExists = await lists.getListItemTemplateExists();
      if (!templateListExists || !listDataStreamExists) {
        await lists.setListTemplate();
      }
      if (!templateListItemsExists || !listItemDataStreamExists) {
        await lists.setListItemTemplate();
      }
      if (listDataStreamExists && listItemDataStreamExists) {
        return siemResponse.error({
          body: `data stream: "${lists.getListName()}" and "${lists.getListItemName()}" already exists`,
          statusCode: 409
        });
      }
      if (!listDataStreamExists) {
        const listIndexExists = await lists.getListIndexExists();
        await (listIndexExists ? lists.migrateListIndexToDataStream() : lists.createListDataStream());
      }
      if (!listItemDataStreamExists) {
        const listItemIndexExists = await lists.getListItemIndexExists();
        await (listItemIndexExists ? lists.migrateListItemIndexToDataStream() : lists.createListItemDataStream());
      }
      return response.ok({
        body: _api.CreateListIndexResponse.parse({
          acknowledged: true
        })
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.createListIndexRoute = createListIndexRoute;