"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.focusMainFlyout = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Return focus to the main flyout div to align with a11y standards
 * @param flyoutId ID of the main flyout div element
 */
const focusMainFlyout = flyoutId => {
  const flyoutElement = document.getElementById(flyoutId);
  if (flyoutElement) {
    flyoutElement.focus();
  }
};
exports.focusMainFlyout = focusMainFlyout;