"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lensUpdateResponseBodySchema = exports.lensUpdateRequestParamsSchema = exports.lensUpdateRequestBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _lodash = require("lodash");
var _content_management = require("../../../../content_management");
var _utils = require("../../../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const lensUpdateRequestParamsSchema = exports.lensUpdateRequestParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.string({
    meta: {
      description: 'The saved object id of a Lens visualization.'
    }
  })
}, {
  unknowns: 'forbid'
});
const lensUpdateRequestBodySchema = exports.lensUpdateRequestBodySchema = _configSchema.schema.object({
  data: _configSchema.schema.object({
    ..._content_management.lensAPIAttributesSchema.getPropSchemas(),
    // omit id on create options
    ...(0, _utils.pickFromObjectSchema)(_content_management.lensAPIConfigSchema.getPropSchemas(), ['references'])
  }, {
    unknowns: 'forbid'
  }),
  // TODO should these options be here?
  options: _configSchema.schema.object({
    ...(0, _lodash.omit)(_content_management.lensCMUpdateOptionsSchema.getPropSchemas(), ['references'])
  }, {
    unknowns: 'forbid'
  })
}, {
  unknowns: 'forbid'
});
const lensUpdateResponseBodySchema = exports.lensUpdateResponseBodySchema = _content_management.lensResponseItemSchema;