"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toExpression = void 0;
var _coloring = require("@kbn/coloring");
var _common = require("@kbn/expressions-plugin/common");
var _charts = require("@elastic/charts");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _metric_visualization = require("./metric_visualization");
var _visualization = require("./visualization");
var _constants = require("./constants");
var _helpers = require("./helpers");
var _shared_components = require("../../shared_components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO - deduplicate with gauges?
function computePaletteParams(paletteService, palette) {
  var _palette$params;
  const stops = (0, _coloring.getOverridePaletteStops)(paletteService, palette);
  return {
    ...palette.params,
    // rewrite colors and stops as two distinct arguments
    colors: stops === null || stops === void 0 ? void 0 : stops.map(({
      color
    }) => color),
    stops: ((_palette$params = palette.params) === null || _palette$params === void 0 ? void 0 : _palette$params.name) === 'custom' ? stops === null || stops === void 0 ? void 0 : stops.map(({
      stop
    }) => stop) : [],
    reverse: false // managed at UI level
  };
}
const getTrendlineExpression = (state, datasourceExpressionsByLayers) => {
  const {
    trendlineLayerId,
    trendlineMetricAccessor,
    trendlineTimeAccessor
  } = state;
  if (!trendlineLayerId || !trendlineMetricAccessor || !trendlineTimeAccessor) {
    return;
  }
  const datasourceExpression = datasourceExpressionsByLayers[trendlineLayerId];
  if (!datasourceExpression) {
    return;
  }
  const metricTrendlineFn = (0, _common.buildExpressionFunction)('metricTrendline', {
    metric: trendlineMetricAccessor,
    timeField: trendlineTimeAccessor,
    breakdownBy: state.trendlineBreakdownByAccessor && !state.collapseFn ? state.trendlineBreakdownByAccessor : undefined,
    inspectorTableId: trendlineLayerId,
    table: [{
      ...datasourceExpression,
      chain: [...datasourceExpression.chain, ...(state.collapseFn ? [(0, _common.buildExpressionFunction)('lens_collapse', {
        by: [trendlineTimeAccessor],
        metric: [trendlineMetricAccessor],
        fn: [state.collapseFn]
      }).toAst()] : [])]
    }]
  });
  return (0, _common.buildExpression)([metricTrendlineFn]).toAst();
};
const toExpression = (paletteService, state, datasourceLayers, datasourceExpressionsByLayers = {}, theme) => {
  var _state$secondaryTrend, _state$subtitle, _state$titlesTextAlig, _state$primaryAlign, _state$secondaryAlign, _state$valueFontMode, _state$primaryPositio, _state$titleWeight, _state$color, _state$palette, _state$maxCols, _state$secondaryLabel, _state$applyColorTo, _datasourceExpression;
  if (!state.metricAccessor) {
    return null;
  }
  const datasource = datasourceLayers[state.layerId];
  const datasourceExpression = datasourceExpressionsByLayers[state.layerId];
  const {
    isNumeric: isMetricNumeric
  } = (0, _shared_components.getAccessorType)(datasource, state.metricAccessor);
  const maxPossibleTiles =
  // if there's a collapse function, no need to calculate since we're dealing with a single tile
  state.breakdownByAccessor && !state.collapseFn ? datasource === null || datasource === void 0 ? void 0 : datasource.getMaxPossibleNumValues(state.breakdownByAccessor) : null;
  const getCollapseFnArguments = () => {
    const metric = [state.metricAccessor, state.secondaryMetricAccessor, state.maxAccessor].filter(Boolean);
    const collapseFn = state.collapseFn;
    const fn = metric.map(accessor => {
      if (accessor !== state.maxAccessor) {
        return collapseFn;
      } else {
        var _datasource$getOperat;
        const isMaxStatic = Boolean(datasource === null || datasource === void 0 ? void 0 : (_datasource$getOperat = datasource.getOperationForColumnId(state.maxAccessor)) === null || _datasource$getOperat === void 0 ? void 0 : _datasource$getOperat.isStaticValue);
        // we do this because the user expects the static value they set to be the same
        // even if they define a collapse on the breakdown by
        return isMaxStatic ? 'max' : collapseFn;
      }
    });
    return {
      by: [],
      metric,
      fn
    };
  };
  const canCollapseBy = state.collapseFn && isMetricNumeric;
  const collapseExpressionFunction = canCollapseBy ? (0, _common.buildExpressionFunction)('lens_collapse', getCollapseFnArguments()).toAst() : undefined;
  const trendlineExpression = getTrendlineExpression(state, datasourceExpressionsByLayers);
  const {
    isNumeric: isNumericType
  } = (0, _shared_components.getAccessorType)(datasource, state.secondaryMetricAccessor);
  const secondaryDynamicColorMode = (0, _helpers.getColorMode)(state.secondaryTrend, isNumericType);

  // Replace the secondary prefix if a dynamic coloring with primary metric baseline is picked
  const secondaryLabelConfig = (0, _helpers.getSecondaryLabelSelected)(state, {
    defaultSecondaryLabel: '',
    colorMode: secondaryDynamicColorMode,
    isPrimaryMetricNumeric: isMetricNumeric
  });
  const secondaryTrendConfig = ((_state$secondaryTrend = state.secondaryTrend) === null || _state$secondaryTrend === void 0 ? void 0 : _state$secondaryTrend.type) === secondaryDynamicColorMode ? state.secondaryTrend : (0, _helpers.getDefaultConfigForMode)(secondaryDynamicColorMode);
  const hasMetricIcon = (0, _visualizationUiComponents.hasIcon)(state.icon);
  // If an icon is present but no iconAlign is set (legacy state), default to 'left' alignment;
  // otherwise, use the configured or default alignment
  let iconAlign;
  if (hasMetricIcon) {
    var _state$iconAlign;
    // Legacy: If iconAlign is missing, default to 'left'
    iconAlign = (_state$iconAlign = state.iconAlign) !== null && _state$iconAlign !== void 0 ? _state$iconAlign : _constants.legacyMetricStateDefaults.iconAlign;
  } else {
    iconAlign = _constants.metricStateDefaults.iconAlign;
  }
  const metricFn = (0, _common.buildExpressionFunction)('metricVis', {
    metric: state.metricAccessor,
    secondaryMetric: state.secondaryMetricAccessor,
    secondaryLabel: secondaryLabelConfig.mode === 'custom' ? secondaryLabelConfig.label : state.secondaryLabel,
    secondaryColor: secondaryTrendConfig.type === 'static' ? secondaryTrendConfig.color : undefined,
    secondaryTrendVisuals: secondaryTrendConfig.type === 'dynamic' ? secondaryTrendConfig.visuals : undefined,
    secondaryTrendBaseline: secondaryTrendConfig.type === 'dynamic' ? (0, _helpers.getSecondaryDynamicTrendBaselineValue)(isMetricNumeric, secondaryTrendConfig.baselineValue) : undefined,
    secondaryTrendPalette: (0, _helpers.getTrendPalette)(secondaryDynamicColorMode, secondaryTrendConfig, theme.getTheme()),
    max: state.maxAccessor,
    breakdownBy: state.breakdownByAccessor && !canCollapseBy ? state.breakdownByAccessor : undefined,
    trendline: trendlineExpression ? [trendlineExpression] : [],
    subtitle: (_state$subtitle = state.subtitle) !== null && _state$subtitle !== void 0 ? _state$subtitle : undefined,
    progressDirection: (0, _metric_visualization.showingBar)(state) ? state.progressDirection || _charts.LayoutDirection.Vertical : undefined,
    titlesTextAlign: (_state$titlesTextAlig = state.titlesTextAlign) !== null && _state$titlesTextAlig !== void 0 ? _state$titlesTextAlig : _constants.metricStateDefaults.titlesTextAlign,
    primaryAlign: (_state$primaryAlign = state.primaryAlign) !== null && _state$primaryAlign !== void 0 ? _state$primaryAlign : _constants.metricStateDefaults.primaryAlign,
    secondaryAlign: (_state$secondaryAlign = state.secondaryAlign) !== null && _state$secondaryAlign !== void 0 ? _state$secondaryAlign : _constants.metricStateDefaults.secondaryAlign,
    iconAlign,
    valueFontSize: (_state$valueFontMode = state.valueFontMode) !== null && _state$valueFontMode !== void 0 ? _state$valueFontMode : _constants.metricStateDefaults.valueFontMode,
    primaryPosition: (_state$primaryPositio = state.primaryPosition) !== null && _state$primaryPositio !== void 0 ? _state$primaryPositio : _constants.metricStateDefaults.primaryPosition,
    titleWeight: (_state$titleWeight = state.titleWeight) !== null && _state$titleWeight !== void 0 ? _state$titleWeight : _constants.metricStateDefaults.titleWeight,
    color: (_state$color = state.color) !== null && _state$color !== void 0 ? _state$color : (0, _visualization.getDefaultColor)(state, isMetricNumeric),
    icon: hasMetricIcon ? state.icon : undefined,
    palette: isMetricNumeric && (_state$palette = state.palette) !== null && _state$palette !== void 0 && _state$palette.params ? [paletteService.get(_coloring.CUSTOM_PALETTE).toExpression(computePaletteParams(paletteService, state.palette))] : [],
    maxCols: (_state$maxCols = state.maxCols) !== null && _state$maxCols !== void 0 ? _state$maxCols : _visualization.DEFAULT_MAX_COLUMNS,
    minTiles: maxPossibleTiles !== null && maxPossibleTiles !== void 0 ? maxPossibleTiles : undefined,
    inspectorTableId: state.layerId,
    secondaryLabelPosition: (_state$secondaryLabel = state.secondaryLabelPosition) !== null && _state$secondaryLabel !== void 0 ? _state$secondaryLabel : _constants.metricStateDefaults.secondaryLabelPosition,
    applyColorTo: (_state$applyColorTo = state.applyColorTo) !== null && _state$applyColorTo !== void 0 ? _state$applyColorTo : _constants.metricStateDefaults.applyColorTo
  });
  return {
    type: 'expression',
    chain: [...((_datasourceExpression = datasourceExpression === null || datasourceExpression === void 0 ? void 0 : datasourceExpression.chain) !== null && _datasourceExpression !== void 0 ? _datasourceExpression : []), ...(collapseExpressionFunction ? [collapseExpressionFunction] : []), metricFn.toAst()]
  };
};
exports.toExpression = toExpression;