"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lensVisTypeAlias = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
var _basic_lens_client = require("./persistence/basic_lens_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const lensVisTypeAlias = exports.lensVisTypeAlias = {
  alias: {
    path: (0, _constants.getBasePath)(),
    app: _constants.APP_ID
  },
  name: _constants.APP_ID,
  promotion: true,
  title: _i18n.i18n.translate('xpack.lens.visTypeAlias.title', {
    defaultMessage: 'Lens'
  }),
  description: _i18n.i18n.translate('xpack.lens.visTypeAlias.description', {
    defaultMessage: 'Create visualizations using an intuitive drag-and-drop interface. Smart suggestions help you follow best practices and find the chart types that best match your data.'
  }),
  order: 60,
  icon: _constants.LENS_ICON,
  stage: _constants.STAGE_ID,
  appExtensions: {
    visualizations: {
      docTypes: [_constants.LENS_EMBEDDABLE_TYPE],
      searchFields: ['title^3'],
      clientOptions: {
        update: {
          overwrite: true
        }
      },
      client: _basic_lens_client.getLensBasicClient,
      toListItem(savedObject) {
        const {
          id,
          type,
          updatedAt,
          attributes,
          managed
        } = savedObject;
        const {
          title,
          description
        } = attributes;
        return {
          id,
          title,
          description,
          updatedAt,
          managed,
          editor: {
            editUrl: (0, _constants.getEditPath)(id),
            editApp: 'lens'
          },
          icon: _constants.LENS_ICON,
          stage: _constants.STAGE_ID,
          savedObjectType: type,
          type: _constants.LENS_EMBEDDABLE_TYPE,
          typeTitle: _i18n.i18n.translate('xpack.lens.visTypeAlias.type', {
            defaultMessage: 'Lens'
          })
        };
      }
    }
  }
};