"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.optimizingMiddleware = void 0;
var _lodash = require("lodash");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** cancels updates to the store that don't change the state */
const optimizingMiddleware = () => store => {
  return next => action => {
    if (_.onActiveDataChange.match(action)) {
      if ((0, _lodash.isEqual)(store.getState().lens.activeData, action.payload.activeData)) {
        return;
      }
    } else if (_.updateDatasourceState.match(action)) {
      const {
        datasourceId,
        newDatasourceState
      } = action.payload;
      const {
        datasourceStates
      } = store.getState().lens;
      if ((0, _lodash.isEqual)(datasourceStates[datasourceId].state, newDatasourceState)) {
        return;
      }
    } else if (_.setExecutionContext.match(action)) {
      const payloadKeys = Object.keys(action.payload);
      const prevState = store.getState().lens;
      const stateSliceToUpdate = payloadKeys.reduce((acc, currentKey) => {
        return {
          ...acc,
          [currentKey]: prevState[currentKey]
        };
      }, {});
      if ((0, _lodash.isEqual)(action.payload, stateSliceToUpdate)) {
        return;
      }
    }
    next(action);
  };
};
exports.optimizingMiddleware = optimizingMiddleware;