"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.referenceLineIconsSet = exports.metricIconsSet = void 0;
var _i18n = require("@kbn/i18n");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const referenceLineIconsSet = exports.referenceLineIconsSet = _visualizationUiComponents.sharedSetOfIcons;
const metricIconsSet = exports.metricIconsSet = [..._visualizationUiComponents.sharedSetOfIcons,
// use spread here to avoid to cast single entries
...[{
  value: 'sortUp',
  label: _i18n.i18n.translate('xpack.lens.metric.iconSelect.sortUpLabel', {
    defaultMessage: 'Sort up'
  })
}, {
  value: 'sortDown',
  label: _i18n.i18n.translate('xpack.lens.metric.iconSelect.sortDownLabel', {
    defaultMessage: 'Sort down'
  })
}, {
  value: 'compute',
  label: _i18n.i18n.translate('xpack.lens.metric.iconSelect.computeLabel', {
    defaultMessage: 'Compute'
  })
}, {
  value: 'globe',
  label: _i18n.i18n.translate('xpack.lens.metric.iconSelect.globeLabel', {
    defaultMessage: 'Globe'
  })
}, {
  value: 'temperature',
  label: _i18n.i18n.translate('xpack.lens.metric.iconSelect.temperatureLabel', {
    defaultMessage: 'Temperature'
  })
}, {
  value: 'heart',
  label: _i18n.i18n.translate('xpack.lens.metric.iconSelect.heartLabel', {
    defaultMessage: 'Heart'
  })
}, {
  value: 'mapMarker',
  label: _i18n.i18n.translate('xpack.lens.metric.iconSelect.mapMarkerLabel', {
    defaultMessage: 'Map Marker'
  })
}, {
  value: 'pin',
  label: _i18n.i18n.translate('xpack.lens.metric.iconSelect.mapPinLabel', {
    defaultMessage: 'Map Pin'
  })
}, {
  value: 'starEmpty',
  label: _i18n.i18n.translate('xpack.lens.metric.iconSelect.starLabel', {
    defaultMessage: 'Star'
  })
}]].sort(_visualizationUiComponents.iconSortCriteria);