"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeSearchContext = initializeSearchContext;
exports.searchContextComparators = void 0;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _publishes_search_session = require("@kbn/presentation-publishing/interfaces/fetch/publishes_search_session");
var _rxjs = require("rxjs");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const searchContextComparators = exports.searchContextComparators = {
  ..._presentationPublishing.timeRangeComparators,
  query: 'skip',
  filters: 'skip',
  timeslice: 'skip',
  searchSessionId: 'skip',
  lastReloadRequestTime: 'skip'
};
function initializeSearchContext(initialState, internalApi, parentApi, {
  injectFilterReferences
}) {
  const searchSessionId$ = (0, _publishes_search_session.apiPublishesSearchSession)(parentApi) ? parentApi.searchSessionId$ : new _rxjs.BehaviorSubject(undefined);
  const attributes = internalApi.attributes$.getValue();
  const lastReloadRequestTime$ = new _rxjs.BehaviorSubject(undefined);

  // Make sure the panel access the filters with the correct references
  const filters$ = new _rxjs.BehaviorSubject(injectFilterReferences(attributes.state.filters, attributes.references));
  const query$ = new _rxjs.BehaviorSubject(attributes.state.query);
  const timeslice$ = new _rxjs.BehaviorSubject(undefined);
  const timeRangeManager = (0, _presentationPublishing.initializeTimeRangeManager)(initialState);
  const subscriptions = [internalApi.attributes$.pipe((0, _rxjs.map)(attrs => attrs.state.query), (0, _rxjs.distinctUntilChanged)(_lodash.isEqual)).subscribe(query$), internalApi.attributes$.pipe((0, _rxjs.map)(attrs => attrs.state.filters), (0, _rxjs.distinctUntilChanged)(_lodash.isEqual)).subscribe(filters$)];
  return {
    api: {
      searchSessionId$,
      filters$,
      query$,
      timeslice$,
      isCompatibleWithUnifiedSearch: () => true,
      ...timeRangeManager.api
    },
    anyStateChange$: (0, _rxjs.merge)(timeRangeManager.anyStateChange$),
    cleanup: () => {
      subscriptions.forEach(sub => sub.unsubscribe());
    },
    getLatestState: () => ({
      searchSessionId: searchSessionId$.getValue(),
      filters: filters$.getValue(),
      query: query$.getValue(),
      timeslice: timeslice$.getValue(),
      lastReloadRequestTime: lastReloadRequestTime$.getValue(),
      ...timeRangeManager.getLatestState()
    }),
    reinitializeState: lastSaved => {
      timeRangeManager.reinitializeState(lastSaved);
    }
  };
}