"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVariables = getVariables;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getInternalTables(states) {
  const result = {};
  if ('textBased' in states) {
    const layers = states.textBased.layers;
    for (const layer in layers) {
      var _layers$layer;
      if ((_layers$layer = layers[layer]) !== null && _layers$layer !== void 0 && _layers$layer.table) {
        result[layer] = layers[layer].table;
      }
    }
  }
  return result;
}

/**
 * Collect all the data that need to be forwarded at the end of the
 * expression pipeline as overrides, palette, etc... and merged them all here
 */
function getVariables(api, state) {
  var _api$defaultTitle$;
  return {
    embeddableTitle: (_api$defaultTitle$ = api.defaultTitle$) === null || _api$defaultTitle$ === void 0 ? void 0 : _api$defaultTitle$.getValue(),
    ...(state.palette ? {
      theme: {
        palette: state.palette
      }
    } : {}),
    ...('overrides' in state ? {
      overrides: state.overrides
    } : {}),
    ...getInternalTables(state.attributes.state.datasourceStates)
  };
}