"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prepareOnRender = prepareOnRender;
var _presentationContainers = require("@kbn/presentation-containers");
var _ebtTools = require("@kbn/ebt-tools");
var _lens_ui_telemetry = require("../../lens_ui_telemetry");
var _report_performance_metric_util = require("../../report_performance_metric_util");
var _logger = require("../logger");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function trackContentfulRender(activeData, parentApi) {
  if (!(0, _presentationContainers.canTrackContentfulRender)(parentApi)) {
    return;
  }
  const hasData = Object.values(activeData).some(table => {
    var _table$meta, _table$meta$statistic;
    if (((_table$meta = table.meta) === null || _table$meta === void 0 ? void 0 : (_table$meta$statistic = _table$meta.statistics) === null || _table$meta$statistic === void 0 ? void 0 : _table$meta$statistic.totalCount) != null) {
      // if totalCount is set, refer to total count
      return table.meta.statistics.totalCount > 0;
    }
    // if not, fall back to check the rows of the table
    return table.rows.length > 0;
  });
  if (hasData) {
    parentApi.trackContentfulRender();
  }
}
function trackPerformanceMetrics(api, coreStart) {
  const inspectorAdapters = api.getInspectorAdapters();
  const timings = (0, _report_performance_metric_util.getSuccessfulRequestTimings)(inspectorAdapters);
  if (timings) {
    const esRequestMetrics = {
      eventName: 'lens_chart_es_request_totals',
      duration: timings.requestTimeTotal,
      key1: 'es_took_total',
      value1: timings.esTookTotal
    };
    (0, _ebtTools.reportPerformanceMetricEvent)(coreStart.analytics, esRequestMetrics);
  }
}
function prepareOnRender(api, internalApi, parentApi, getState, {
  datasourceMap,
  visualizationMap,
  coreStart
}, executionContext, dispatchRenderComplete) {
  return function onRender$(count) {
    var _api$getInspectorAdap;
    (0, _logger.addLog)(`onRender$ ${count}`);
    // for some reason onRender$ is emitting multiple times with the same render count
    // so avoid to repeat the same logic on duplicate calls
    if (count === internalApi.renderCount$.getValue()) {
      return;
    }
    let datasourceEvents = [];
    let visualizationEvents = [];
    const currentState = getState();
    if (currentState) {
      datasourceEvents = Object.values(datasourceMap).reduce((acc, datasource) => {
        var _datasource$getRender, _datasource$getRender2;
        return [...acc, ...((_datasource$getRender = (_datasource$getRender2 = datasource.getRenderEventCounters) === null || _datasource$getRender2 === void 0 ? void 0 : _datasource$getRender2.call(datasource, currentState.attributes.state.datasourceStates[datasource.id])) !== null && _datasource$getRender !== void 0 ? _datasource$getRender : [])];
      }, []);
      if (currentState.attributes.visualizationType) {
        var _visualizationMap$cur, _visualizationMap$cur2, _visualizationMap$cur3;
        visualizationEvents = (_visualizationMap$cur = (_visualizationMap$cur2 = (_visualizationMap$cur3 = visualizationMap[currentState.attributes.visualizationType]).getRenderEventCounters) === null || _visualizationMap$cur2 === void 0 ? void 0 : _visualizationMap$cur2.call(_visualizationMap$cur3, currentState.attributes.state.visualization)) !== null && _visualizationMap$cur !== void 0 ? _visualizationMap$cur : [];
      }
    }
    const events = [...datasourceEvents, ...visualizationEvents, ...(0, _lens_ui_telemetry.getExecutionContextEvents)(executionContext)];
    const adHocDataViews = Object.values(currentState.attributes.state.adHocDataViews || {});
    adHocDataViews.forEach(() => {
      events.push('ad_hoc_data_view');
    });
    (0, _lens_ui_telemetry.trackUiCounterEvents)(events, executionContext);
    trackContentfulRender((_api$getInspectorAdap = api.getInspectorAdapters().tables) === null || _api$getInspectorAdap === void 0 ? void 0 : _api$getInspectorAdap.tables, parentApi);
    dispatchRenderComplete();
    trackPerformanceMetrics(api, coreStart);
  };
}