"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractAggId = void 0;
exports.getESQLForLayer = getESQLForLayer;
var _public = require("@kbn/data-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _moment = _interopRequireDefault(require("moment"));
var _lodash = require("lodash");
var _helpers = require("./operations/definitions/helpers");
var _utils = require("../../utils");
var _operations = require("./operations");
var _time_shift_utils = require("./time_shift_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// esAggs column ID manipulation functions
const extractAggId = id => id.split('.')[0].split('-')[2];
// Need a more complex logic for decimals percentiles
exports.extractAggId = extractAggId;
function getESQLForLayer(esAggEntries, layer, indexPattern, uiSettings, dateRange, nowInstant) {
  // esql mode variables
  const partialRows = true;
  const timeZone = (0, _common.getUserTimeZone)(key => uiSettings.get(key), true);
  const utcOffset = _moment.default.tz(timeZone).utcOffset() / 60;
  if (utcOffset !== 0) return;
  if (Object.values(layer.columns).find(col => {
    var _indexPattern$getFiel;
    return col.operationType === 'formula' || col.timeShift || 'sourceField' in col && ((_indexPattern$getFiel = indexPattern.getFieldByName(col.sourceField)) === null || _indexPattern$getFiel === void 0 ? void 0 : _indexPattern$getFiel.runtime);
  })) return;

  // indexPattern.title is the actual es pattern
  const esql = [`FROM ${indexPattern.title}`];
  if (indexPattern.timeFieldName) {
    esql.push(`WHERE ${indexPattern.timeFieldName} >= ?_tstart AND ${indexPattern.timeFieldName} <= ?_tend`);
  }
  const histogramBarsTarget = uiSettings.get(_public.UI_SETTINGS.HISTOGRAM_BAR_TARGET);
  const absDateRange = (0, _utils.convertToAbsoluteDateRange)(dateRange, nowInstant);
  const firstDateHistogramColumn = esAggEntries.find(([, col]) => col.operationType === 'date_histogram');
  const hasDateHistogram = Boolean(firstDateHistogramColumn);
  const esAggsIdMap = {};
  const [metricEsAggsEntries, bucketEsAggsEntries] = (0, _lodash.partition)(esAggEntries, ([_, col]) => !col.isBucketed);
  const metrics = metricEsAggsEntries.map(([colId, col], index) => {
    var _col$filter, _operationDefinitionM, _operationDefinitionM2, _operationDefinitionM3;
    const def = _operations.operationDefinitionMap[col.operationType];
    if (!def.toESQL) return undefined;
    const aggId = String(index);
    const wrapInFilter = Boolean(def.filterable && ((_col$filter = col.filter) === null || _col$filter === void 0 ? void 0 : _col$filter.query));
    const wrapInTimeFilter = def.canReduceTimeRange && !hasDateHistogram && col.reducedTimeRange && indexPattern.timeFieldName;
    if (wrapInTimeFilter) {
      return undefined;
    }
    const esAggsId = window.ELASTIC_LENS_DELAY_SECONDS ? `bucket_${index + 1}_${aggId}` : `bucket_${index}_${aggId}`;
    const format = (_operationDefinitionM = (_operationDefinitionM2 = (_operationDefinitionM3 = _operations.operationDefinitionMap[col.operationType]).getSerializedFormat) === null || _operationDefinitionM2 === void 0 ? void 0 : _operationDefinitionM2.call(_operationDefinitionM3, col, col, indexPattern, uiSettings, dateRange)) !== null && _operationDefinitionM !== void 0 ? _operationDefinitionM : 'sourceField' in col ? col.sourceField === '___records___' ? {
      id: 'number'
    } : indexPattern.getFormatterForField(col.sourceField) : undefined;
    esAggsIdMap[esAggsId] = [{
      ...col,
      id: colId,
      format: format,
      interval: undefined,
      label: col.customLabel ? col.label : _operations.operationDefinitionMap[col.operationType].getDefaultLabel(col, layer.columns, indexPattern, uiSettings, dateRange)
    }];
    let metricESQL = def.toESQL({
      ...col,
      timeShift: (0, _time_shift_utils.resolveTimeShift)(col.timeShift, absDateRange, histogramBarsTarget, hasDateHistogram)
    }, wrapInFilter || wrapInTimeFilter ? `${aggId}-metric` : aggId, indexPattern, layer, uiSettings, dateRange);
    if (!metricESQL) return undefined;
    metricESQL = `${esAggsId} = ` + metricESQL;
    if (wrapInFilter) {
      var _col$filter2, _col$filter3;
      if (((_col$filter2 = col.filter) === null || _col$filter2 === void 0 ? void 0 : _col$filter2.language) === 'kuery') {
        metricESQL += ` WHERE KQL("""${col.filter.query.replace(/"""/g, '')}""")`;
      } else if (((_col$filter3 = col.filter) === null || _col$filter3 === void 0 ? void 0 : _col$filter3.language) === 'lucene') {
        metricESQL += ` WHERE QSTR("""${col.filter.query.replace(/"""/g, '')}""")`;
      } else {
        return;
      }
    }
    return metricESQL;
  });
  if (metrics.some(m => !m)) return;
  let stats = `STATS ${metrics.join(', ')}`;
  const buckets = bucketEsAggsEntries.map(([colId, col], index) => {
    var _col$filter4, _operationDefinitionM4, _operationDefinitionM5, _operationDefinitionM6;
    const def = _operations.operationDefinitionMap[col.operationType];
    if (!def.toESQL) return undefined;
    const aggId = String(index);
    const wrapInFilter = Boolean(def.filterable && ((_col$filter4 = col.filter) === null || _col$filter4 === void 0 ? void 0 : _col$filter4.query));
    const wrapInTimeFilter = def.canReduceTimeRange && !hasDateHistogram && col.reducedTimeRange && indexPattern.timeFieldName;
    let esAggsId = window.ELASTIC_LENS_DELAY_SECONDS ? `col_${index}-${aggId}` : `col_${index}_${aggId}`;
    let interval;
    if ((0, _helpers.isColumnOfType)('date_histogram', col)) {
      var _dateHistogramColumn$, _dateHistogramColumn$2;
      const dateHistogramColumn = col;
      const calcAutoInterval = (0, _common.getCalculateAutoTimeExpression)(key => uiSettings.get(key));
      const cleanInterval = i => {
        switch (i) {
          case 'd':
            return '1d';
          case 'h':
            return '1h';
          case 'm':
            return '1m';
          case 's':
            return '1s';
          case 'ms':
            return '1ms';
          default:
            return i;
        }
      };
      esAggsId = dateHistogramColumn.sourceField;
      const kibanaInterval = ((_dateHistogramColumn$ = dateHistogramColumn.params) === null || _dateHistogramColumn$ === void 0 ? void 0 : _dateHistogramColumn$.interval) === 'auto' ? calcAutoInterval({
        from: dateRange.fromDate,
        to: dateRange.toDate
      }) || '1h' : ((_dateHistogramColumn$2 = dateHistogramColumn.params) === null || _dateHistogramColumn$2 === void 0 ? void 0 : _dateHistogramColumn$2.interval) || '1h';
      const esInterval = (0, _public.convertIntervalToEsInterval)(cleanInterval(kibanaInterval));
      interval = _moment.default.duration(esInterval.value, esInterval.unit).as('ms');
    }
    const format = (_operationDefinitionM4 = (_operationDefinitionM5 = (_operationDefinitionM6 = _operations.operationDefinitionMap[col.operationType]).getSerializedFormat) === null || _operationDefinitionM5 === void 0 ? void 0 : _operationDefinitionM5.call(_operationDefinitionM6, col, col, indexPattern, uiSettings, dateRange)) !== null && _operationDefinitionM4 !== void 0 ? _operationDefinitionM4 : 'sourceField' in col ? indexPattern.getFormatterForField(col.sourceField) : undefined;
    esAggsIdMap[esAggsId] = [{
      ...col,
      id: colId,
      format: format,
      interval: interval,
      ...('sourceField' in col ? {
        sourceField: col.sourceField
      } : {}),
      label: col.customLabel ? col.label : _operations.operationDefinitionMap[col.operationType].getDefaultLabel(col, layer.columns, indexPattern, uiSettings, dateRange)
    }];
    if ((0, _helpers.isColumnOfType)('date_histogram', col)) {
      var _column$params, _indexPattern$getFiel2, _column$params2;
      const column = col;
      if ((_column$params = column.params) !== null && _column$params !== void 0 && _column$params.dropPartials && (
      // set to false when detached from time picker
      indexPattern.timeFieldName === ((_indexPattern$getFiel2 = indexPattern.getFieldByName(column.sourceField)) === null || _indexPattern$getFiel2 === void 0 ? void 0 : _indexPattern$getFiel2.name) || !((_column$params2 = column.params) !== null && _column$params2 !== void 0 && _column$params2.ignoreTimeRange))) {
        return undefined;
      }
    }
    return `${esAggsId} = ` + def.toESQL({
      ...col,
      timeShift: (0, _time_shift_utils.resolveTimeShift)(col.timeShift, absDateRange, histogramBarsTarget, hasDateHistogram)
    }, wrapInFilter || wrapInTimeFilter ? `${aggId}-metric` : aggId, indexPattern, layer, uiSettings, dateRange);
  });
  if (buckets.some(m => !m)) return;
  if (buckets.length > 0) {
    stats += ` BY ${buckets.join(', ')}`;
    esql.push(stats);
    if (buckets.some(b => !b || b.includes('undefined'))) return;
    const sorts = bucketEsAggsEntries.map(([colId, col], index) => {
      const aggId = String(index);
      let esAggsId = window.ELASTIC_LENS_DELAY_SECONDS ? `col_${index}-${aggId}` : `col_${index}_${aggId}`;
      if ((0, _helpers.isColumnOfType)('date_histogram', col)) {
        esAggsId = col.sourceField;
      }
      return `${esAggsId} ASC`;
    });
    esql.push(`SORT ${sorts.join(', ')}`);
  } else {
    esql.push(stats);
  }
  return {
    esql: esql.join(' | '),
    partialRows,
    esAggsIdMap
  };
}