"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeLayer = mergeLayer;
exports.mergeLayers = mergeLayers;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mergeLayer({
  state,
  layerId,
  newLayer
}) {
  return {
    ...state,
    layers: {
      ...state.layers,
      [layerId]: {
        ...state.layers[layerId],
        ...newLayer
      }
    }
  };
}
function mergeLayers({
  state,
  newLayers
}) {
  return {
    ...state,
    layers: {
      ...state.layers,
      ...newLayers
    }
  };
}