"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangePopover = exports.AdvancedRangeEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _react2 = require("@emotion/react");
var _shared_components = require("../../../../../shared_components");
var _ranges = require("./ranges");
var _constants = require("./constants");
var _shared_components2 = require("../shared_components");
var _helpers = require("../helpers");
var _styles = require("../styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/operations/definitions/ranges/advanced_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const generateId = (0, _eui.htmlIdGenerator)();
const getBetterLabel = (range, formatter) => range.label || formatter.convert({
  gte: (0, _helpers.isValidNumber)(range.from) ? range.from : -Infinity,
  lt: (0, _helpers.isValidNumber)(range.to) ? range.to : Infinity
});
const RangePopover = ({
  range,
  setRange,
  button,
  triggerClose,
  isOpen
}) => {
  const [tempRange, setTempRange] = (0, _react.useState)(range);
  const labelRef = _react.default.useRef();
  const toRef = _react.default.useRef();
  const saveRangeAndReset = (newRange, resetRange = false) => {
    if (resetRange) {
      // reset the temporary range for later use
      setTempRange(range);
    }
    // send the range back to the main state
    setRange(newRange);
  };
  const {
    from,
    to,
    label
  } = tempRange;
  const lteAppendLabel = _i18n.i18n.translate('xpack.lens.indexPattern.ranges.lessThanOrEqualAppend', {
    defaultMessage: '\u2264'
  });
  const lteTooltipContent = _i18n.i18n.translate('xpack.lens.indexPattern.ranges.lessThanOrEqualTooltip', {
    defaultMessage: 'Less than or equal to'
  });
  const ltPrependLabel = _i18n.i18n.translate('xpack.lens.indexPattern.ranges.lessThanPrepend', {
    defaultMessage: '\u003c'
  });
  const ltTooltipContent = _i18n.i18n.translate('xpack.lens.indexPattern.ranges.lessThanTooltip', {
    defaultMessage: 'Less than'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    display: "block",
    ownFocus: true,
    isOpen: isOpen,
    closePopover: () => triggerClose(),
    button: button,
    "data-test-subj": "indexPattern-ranges-popover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    css: (0, _react2.css)`
                width: 14ch; // Roughly 10 characters plus extra for the padding
              `,
    value: (0, _helpers.isValidNumber)(from) ? Number(from) : '',
    onChange: ({
      target
    }) => {
      const newRange = {
        ...tempRange,
        from: target.value !== '' ? Number(target.value) : -Infinity
      };
      setTempRange(newRange);
      saveRangeAndReset(newRange);
    },
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: lteTooltipContent,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      tabIndex: 0,
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 19
      }
    }, lteAppendLabel)),
    onKeyDown: ({
      key
    }) => {
      if (_eui.keys.ENTER === key && toRef.current) {
        toRef.current.focus();
      }
    },
    compressed: true,
    placeholder: _constants.FROM_PLACEHOLDER,
    isInvalid: !(0, _ranges.isValidRange)(tempRange),
    step: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortRight",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    css: (0, _react2.css)`
                width: 14ch; // Roughly 10 characters plus extra for the padding
              `,
    value: (0, _helpers.isValidNumber)(to) ? Number(to) : '',
    inputRef: node => {
      if (toRef && node) {
        toRef.current = node;
      }
    },
    onChange: ({
      target
    }) => {
      const newRange = {
        ...tempRange,
        to: target.value !== '' ? Number(target.value) : Infinity
      };
      setTempRange(newRange);
      saveRangeAndReset(newRange);
    },
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: ltTooltipContent,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      tabIndex: 0,
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 19
      }
    }, ltPrependLabel)),
    compressed: true,
    placeholder: _constants.TO_PLACEHOLDER,
    isInvalid: !(0, _ranges.isValidRange)(tempRange),
    onKeyDown: ({
      key
    }) => {
      if (_eui.keys.ENTER === key && labelRef.current) {
        labelRef.current.focus();
      }
    },
    step: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_components2.LabelInput, {
    inputRef: labelRef,
    value: label || '',
    onChange: newLabel => {
      const newRange = {
        ...tempRange,
        label: newLabel
      };
      setTempRange(newRange);
      saveRangeAndReset(newRange);
    },
    placeholder: _i18n.i18n.translate('xpack.lens.indexPattern.ranges.customRangeLabelPlaceholder', {
      defaultMessage: 'Custom label'
    }),
    onSubmit: () => {
      triggerClose();
    },
    compressed: true,
    dataTestSubj: "indexPattern-ranges-label",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 9
    }
  })));
};
exports.RangePopover = RangePopover;
const AdvancedRangeEditor = ({
  ranges,
  setRanges,
  onToggleEditor,
  formatter
}) => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const [activeRangeId, setActiveRangeId] = (0, _react.useState)('');
  // use a local state to store ids with range objects
  const [localRanges, setLocalRanges] = (0, _react.useState)(() => ranges.map(range => ({
    ...range,
    id: generateId()
  })));

  // Update locally all the time, but bounce the parents prop function to avoid too many requests
  // Avoid to trigger on first render
  (0, _shared_components.useDebounceWithOptions)(() => {
    setRanges(localRanges.map(({
      id,
      ...rest
    }) => ({
      ...rest
    })));
  }, {
    skipFirstRender: true
  }, _constants.TYPING_DEBOUNCE_TIME, [localRanges]);
  const addNewRange = (0, _react.useCallback)(() => {
    const newRangeId = generateId();
    setLocalRanges([...localRanges, {
      id: newRangeId,
      from: localRanges[localRanges.length - 1].to,
      to: Number.POSITIVE_INFINITY,
      label: ''
    }]);
    setActiveRangeId(newRangeId);
  }, [localRanges]);
  const changeActiveRange = rangeId => {
    let newActiveRangeId = rangeId;
    if (activeRangeId === rangeId) {
      newActiveRangeId = ''; // toggle off
    }
    setActiveRangeId(newActiveRangeId);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.indexPattern.ranges.customRanges', {
      defaultMessage: 'Ranges'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 265,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      color: "danger",
      onClick: onToggleEditor,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 266,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      type: "cross",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 267,
        columnNumber: 13
      }
    }), ' ', _i18n.i18n.translate('xpack.lens.indexPattern.ranges.customRangesRemoval', {
      defaultMessage: 'Remove custom ranges'
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.DragDropBuckets, {
    onDragEnd: setLocalRanges,
    droppableId: "RANGES_DROPPABLE_AREA",
    items: localRanges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 9
    }
  }, localRanges.map((range, idx, arrayRef) => /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.DraggableBucketContainer, {
    key: range.id,
    idx: idx,
    id: range.id,
    isInvalid: !(0, _ranges.isValidRange)(range),
    invalidMessage: _i18n.i18n.translate('xpack.lens.indexPattern.range.isInvalid', {
      defaultMessage: 'This range is invalid'
    }),
    onRemoveClick: () => {
      const newRanges = arrayRef.filter((_, i) => i !== idx);
      setLocalRanges(newRanges);
    },
    removeTitle: _i18n.i18n.translate('xpack.lens.indexPattern.ranges.deleteRange', {
      defaultMessage: 'Delete range'
    }),
    isNotRemovable: arrayRef.length === 1,
    isNotDraggable: arrayRef.length < 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(RangePopover, {
    range: range,
    isOpen: range.id === activeRangeId,
    triggerClose: () => changeActiveRange(''),
    setRange: newRange => {
      const newRanges = [...arrayRef];
      if (newRange.id === newRanges[idx].id) {
        newRanges[idx] = newRange;
      } else {
        newRanges.push(newRange);
      }
      setLocalRanges(newRanges);
    },
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      color: "text",
      onClick: () => changeActiveRange(range.id),
      "data-test-subj": "dataView-ranges-popover-trigger",
      css: (0, _styles.draggablePopoverButtonStyles)(euiThemeContext),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 314,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      textAlign: "left",
      color: (0, _ranges.isValidRange)(range) ? 'default' : 'danger',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 320,
        columnNumber: 21
      }
    }, getBetterLabel(range, formatter))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.NewBucketButton, {
    onClick: addNewRange,
    label: _i18n.i18n.translate('xpack.lens.indexPattern.ranges.addRange', {
      defaultMessage: 'Add range'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 9
    }
  })));
};
exports.AdvancedRangeEditor = AdvancedRangeEditor;