"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGroupByKey = void 0;
exports.groupByKey = groupByKey;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function groupByKey(items, getKey) {
  const groups = {};
  items.forEach(item => {
    const key = getKey(item);
    if (key) {
      if (!(key in groups)) {
        groups[key] = [];
      }
      groups[key].push(item);
    }
  });
  return groups;
}

/**
 * Computes a group-by key for an agg expression builder based on distinctive expression function arguments
 */
const getGroupByKey = (agg, aggNames, importantExpressionArgs) => {
  const {
    functions: [fnBuilder]
  } = agg;
  const pieces = [];
  if (aggNames.includes(fnBuilder.name)) {
    var _fnBuilder$getArgumen2;
    pieces.push(fnBuilder.name);
    importantExpressionArgs.forEach(({
      name,
      transformer
    }) => {
      var _fnBuilder$getArgumen;
      const arg = (_fnBuilder$getArgumen = fnBuilder.getArgument(name)) === null || _fnBuilder$getArgumen === void 0 ? void 0 : _fnBuilder$getArgumen[0];
      pieces.push(transformer ? transformer(arg) : arg);
    });
    pieces.push((_fnBuilder$getArgumen2 = fnBuilder.getArgument('timeShift')) === null || _fnBuilder$getArgumen2 === void 0 ? void 0 : _fnBuilder$getArgumen2[0]);
  }
  if (fnBuilder.name === 'aggFilteredMetric') {
    var _fnBuilder$getArgumen3;
    const metricFnBuilder = (_fnBuilder$getArgumen3 = fnBuilder.getArgument('customMetric')) === null || _fnBuilder$getArgumen3 === void 0 ? void 0 : _fnBuilder$getArgumen3[0].functions[0];
    if (metricFnBuilder && aggNames.includes(metricFnBuilder.name)) {
      var _fnBuilder$getArgumen4, _aggFilterFnBuilder$g;
      pieces.push(metricFnBuilder.name);
      pieces.push('filtered');
      const aggFilterFnBuilder = ((_fnBuilder$getArgumen4 = fnBuilder.getArgument('customBucket')) === null || _fnBuilder$getArgumen4 === void 0 ? void 0 : _fnBuilder$getArgumen4[0]).functions[0];
      importantExpressionArgs.forEach(({
        name,
        transformer
      }) => {
        var _metricFnBuilder$getA;
        const arg = (_metricFnBuilder$getA = metricFnBuilder.getArgument(name)) === null || _metricFnBuilder$getA === void 0 ? void 0 : _metricFnBuilder$getA[0];
        pieces.push(transformer ? transformer(arg) : arg);
      });
      pieces.push(aggFilterFnBuilder.getArgument('timeWindow'));
      pieces.push(fnBuilder.getArgument('timeShift'));
      const filterExpression = (_aggFilterFnBuilder$g = aggFilterFnBuilder.getArgument('filter')) === null || _aggFilterFnBuilder$g === void 0 ? void 0 : _aggFilterFnBuilder$g[0];
      if (filterExpression) {
        var _filterFnBuilder$getA;
        const filterFnBuilder = filterExpression.functions[0];
        pieces.push(filterFnBuilder === null || filterFnBuilder === void 0 ? void 0 : filterFnBuilder.name, filterFnBuilder === null || filterFnBuilder === void 0 ? void 0 : (_filterFnBuilder$getA = filterFnBuilder.getArgument('q')) === null || _filterFnBuilder$getA === void 0 ? void 0 : _filterFnBuilder$getA[0]);
      }
    }
  }
  return pieces.length ? pieces.map(String).join('-') : undefined;
};
exports.getGroupByKey = getGroupByKey;