"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.retrieveLayerColumnsFromCache = exports.getColumnsFromCache = exports.addColumnsToCache = void 0;
var _esQuery = require("@kbn/es-query");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cachedColumns = new Map();
const getKey = query => {
  const language = (0, _esQuery.getAggregateQueryMode)(query);
  const queryString = query[language];
  return queryString.replaceAll('\n', '').trim();
};
const addColumnsToCache = (query, list) => {
  const trimmedQuery = getKey(query);
  cachedColumns.set(trimmedQuery, list);
};
exports.addColumnsToCache = addColumnsToCache;
const getColumnsFromCache = query => {
  var _cachedColumns$get;
  const trimmedQuery = getKey(query);
  return (_cachedColumns$get = cachedColumns.get(trimmedQuery)) !== null && _cachedColumns$get !== void 0 ? _cachedColumns$get : [];
};
exports.getColumnsFromCache = getColumnsFromCache;
const retrieveLayerColumnsFromCache = (existingColumns, query) => {
  const columnsFromCache = query ? getColumnsFromCache(query) : [];
  return (0, _utils.getAllColumns)(existingColumns, columnsFromCache);
};
exports.retrieveLayerColumnsFromCache = retrieveLayerColumnsFromCache;