"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormatSelector = FormatSelector;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _visualizationUtils = require("@kbn/visualization-utils");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/field-formats-plugin/common");
var _react2 = require("@emotion/react");
var _helpers = require("../operations/definitions/helpers");
var _duration_input = require("./formatting/duration_input");
var _prepend_provider = require("../../../shared_components/prepend_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/dimension_panel/format_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const supportedFormats = {
  number: {
    title: _i18n.i18n.translate('xpack.lens.indexPattern.numberFormatLabel', {
      defaultMessage: 'Number'
    }),
    supportsDecimals: true,
    supportsSuffix: true,
    supportsCompact: true
  },
  percent: {
    title: _i18n.i18n.translate('xpack.lens.indexPattern.percentFormatLabel', {
      defaultMessage: 'Percent'
    }),
    supportsDecimals: true,
    supportsSuffix: true,
    supportsCompact: true
  },
  bytes: {
    title: _i18n.i18n.translate('xpack.lens.indexPattern.bytesFormatLabel', {
      defaultMessage: 'Bytes (1024)'
    }),
    supportsDecimals: true,
    supportsSuffix: true,
    supportsCompact: false
  },
  bits: {
    title: _i18n.i18n.translate('xpack.lens.indexPattern.bitsFormatLabel', {
      defaultMessage: 'Bits (1000)'
    }),
    defaultDecimals: 0,
    supportsDecimals: true,
    supportsSuffix: true,
    supportsCompact: false
  },
  duration: {
    title: _i18n.i18n.translate('xpack.lens.indexPattern.durationLabel', {
      defaultMessage: 'Duration'
    }),
    defaultDecimals: 0,
    supportsDecimals: true,
    supportsSuffix: true,
    supportsCompact: true
  },
  custom: {
    title: _i18n.i18n.translate('xpack.lens.indexPattern.customFormatLabel', {
      defaultMessage: 'Custom format'
    }),
    defaultDecimals: 0,
    supportsDecimals: false,
    supportsSuffix: false,
    supportsCompact: false
  }
};
const defaultOption = {
  value: '',
  label: _i18n.i18n.translate('xpack.lens.indexPattern.defaultFormatLabel', {
    defaultMessage: 'Default'
  })
};
const singleSelectionOption = {
  asPlainText: true
};
const label = _i18n.i18n.translate('xpack.lens.indexPattern.columnFormatLabel', {
  defaultMessage: 'Value format'
});
const decimalsLabel = _i18n.i18n.translate('xpack.lens.indexPattern.decimalPlacesLabel', {
  defaultMessage: 'Decimals'
});
const suffixLabel = _i18n.i18n.translate('xpack.lens.indexPattern.suffixLabel', {
  defaultMessage: 'Suffix'
});
const compactLabel = _i18n.i18n.translate('xpack.lens.indexPattern.compactLabel', {
  defaultMessage: 'Compact values'
});
const RANGE_MIN = 0;
const RANGE_MAX = 15;
function useDebouncedInputforParam(name, defaultValue, currentFormat, onChange) {
  var _currentFormat$params;
  const onChangeParam = (0, _react.useCallback)(value => {
    if (!currentFormat) {
      return;
    }
    onChange({
      id: currentFormat.id,
      params: {
        ...currentFormat.params,
        [name]: value
      }
    });
  }, [currentFormat, name, onChange]);
  const {
    handleInputChange: setter,
    inputValue: value
  } = (0, _visualizationUtils.useDebouncedValue)({
    onChange: onChangeParam,
    value: (currentFormat === null || currentFormat === void 0 ? void 0 : (_currentFormat$params = currentFormat.params) === null || _currentFormat$params === void 0 ? void 0 : _currentFormat$params[name]) || defaultValue
  }, {
    allowFalsyValue: true
  });
  return {
    setter,
    value
  };
}
function FormatSelector(props) {
  var _selectedColumn$param, _currentFormat$params2, _currentFormat$params3;
  const {
    uiSettings
  } = (0, _public.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    selectedColumn,
    onChange,
    docLinks
  } = props;
  const currentFormat = (0, _helpers.isColumnFormatted)(selectedColumn) ? (_selectedColumn$param = selectedColumn.params) === null || _selectedColumn$param === void 0 ? void 0 : _selectedColumn$param.format : undefined;
  const [decimals, setDecimals] = (0, _react.useState)((_currentFormat$params2 = currentFormat === null || currentFormat === void 0 ? void 0 : (_currentFormat$params3 = currentFormat.params) === null || _currentFormat$params3 === void 0 ? void 0 : _currentFormat$params3.decimals) !== null && _currentFormat$params2 !== void 0 ? _currentFormat$params2 : 2);
  const {
    setter: setSuffix,
    value: suffix
  } = useDebouncedInputforParam('suffix', '', currentFormat, onChange);
  const {
    setter: setCompact,
    value: compact
  } = useDebouncedInputforParam('compact', false, currentFormat, onChange);
  const defaultNumeralPatternInKibana = uiSettings.get(_common.FORMATS_UI_SETTINGS.FORMAT_NUMBER_DEFAULT_PATTERN);
  const {
    setter: setPattern,
    value: pattern
  } = useDebouncedInputforParam('pattern', defaultNumeralPatternInKibana, currentFormat, onChange);
  const {
    setter: setDurationFrom,
    value: durationFrom
  } = useDebouncedInputforParam('fromUnit', _common.DEFAULT_DURATION_INPUT_FORMAT.kind, currentFormat, onChange);
  const {
    setter: setDurationTo,
    value: durationTo
  } = useDebouncedInputforParam('toUnit', _common.DEFAULT_DURATION_OUTPUT_FORMAT.method, currentFormat, onChange);
  const selectedFormat = currentFormat !== null && currentFormat !== void 0 && currentFormat.id ? supportedFormats[currentFormat.id] : undefined;
  const stableOptions = (0, _react.useMemo)(() => [defaultOption, ...Object.entries(supportedFormats).map(([id, format]) => {
    var _format$title;
    return {
      value: id,
      label: (_format$title = format.title) !== null && _format$title !== void 0 ? _format$title : id
    };
  })], []);
  const onChangeWrapped = (0, _react.useCallback)(choices => {
    if (choices.length === 0) {
      return;
    }
    if (!choices[0].value) {
      onChange();
      return;
    }
    const id = choices[0].value;
    const defaultDecimals = supportedFormats[id].defaultDecimals;
    onChange({
      id: choices[0].value,
      params: {
        decimals: defaultDecimals !== null && defaultDecimals !== void 0 ? defaultDecimals : decimals
      }
    });
    setDecimals(defaultDecimals !== null && defaultDecimals !== void 0 ? defaultDecimals : decimals);
  }, [onChange, decimals]);
  const currentOption = (0, _react.useMemo)(() => {
    var _selectedFormat$title;
    return currentFormat ? [{
      value: currentFormat.id,
      label: (_selectedFormat$title = selectedFormat === null || selectedFormat === void 0 ? void 0 : selectedFormat.title) !== null && _selectedFormat$title !== void 0 ? _selectedFormat$title : currentFormat.id
    }] : [defaultOption];
  }, [currentFormat, selectedFormat === null || selectedFormat === void 0 ? void 0 : selectedFormat.title]);
  const approximatedFormat = (currentFormat === null || currentFormat === void 0 ? void 0 : currentFormat.id) === 'duration' && durationTo === 'humanize';
  return /*#__PURE__*/_react.default.createElement(_prepend_provider.PrependWidthProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    display: "columnCompressed",
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    compressed: true,
    isClearable: false,
    "data-test-subj": "indexPattern-dimension-format",
    "aria-label": label,
    singleSelection: singleSelectionOption,
    options: stableOptions,
    selectedOptions: currentOption,
    onChange: onChangeWrapped,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 13
    }
  }), currentFormat && selectedFormat ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (currentFormat === null || currentFormat === void 0 ? void 0 : currentFormat.id) === 'duration' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_duration_input.DurationRowInputs, {
    onStartChange: setDurationFrom,
    onEndChange: setDurationTo,
    startValue: durationFrom,
    endValue: durationTo,
    testSubjEnd: "indexPattern-dimension-duration-end",
    testSubjStart: "indexPattern-dimension-duration-start",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 21
    }
  })) : null, selectedFormat.supportsDecimals && !approximatedFormat ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    showInput: "inputWithPopover",
    value: decimals,
    min: RANGE_MIN,
    max: RANGE_MAX,
    onChange: e => {
      const value = Number(e.currentTarget.value);
      setDecimals(value);
      const validatedValue = Math.min(RANGE_MAX, Math.max(RANGE_MIN, value));
      onChange({
        id: currentFormat.id,
        params: {
          ...currentFormat.params,
          decimals: validatedValue
        }
      });
    },
    "data-test-subj": "indexPattern-dimension-formatDecimals",
    compressed: true,
    fullWidth: true,
    prepend: /*#__PURE__*/_react.default.createElement(_prepend_provider.Prepend, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 32
      }
    }, decimalsLabel),
    "aria-label": decimalsLabel,
    disabled: approximatedFormat,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 21
    }
  })) : null, selectedFormat.supportsSuffix ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: suffix,
    onChange: e => {
      setSuffix(e.currentTarget.value);
    },
    "data-test-subj": "indexPattern-dimension-formatSuffix",
    compressed: true,
    fullWidth: true,
    prepend: /*#__PURE__*/_react.default.createElement(_prepend_provider.Prepend, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 338,
        columnNumber: 32
      }
    }, suffixLabel),
    "aria-label": suffixLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 21
    }
  })) : null, selectedFormat.supportsCompact && !approximatedFormat ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      css: (0, _react2.css)`
                            font-weight: ${euiTheme.font.weight.regular};
                          `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 349,
        columnNumber: 25
      }
    }, compactLabel),
    checked: Boolean(compact),
    onChange: () => setCompact(!compact),
    "data-test-subj": "lns-indexpattern-dimension-formatCompact",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 21
    }
  })) : null) : null)), (currentFormat === null || currentFormat === void 0 ? void 0 : currentFormat.id) === 'custom' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    hasEmptyLabelSpace: true,
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLinks.links.indexPatterns.fieldFormattersNumber,
      target: "_blank",
      external: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 372,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.lens.indexPattern.custom.externalDoc', {
      defaultMessage: 'Numeral formatting syntax'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 368,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": 'numberEditorFormatPattern',
    compressed: true,
    prepend: /*#__PURE__*/_react.default.createElement(_prepend_provider.Prepend, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 387,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.lens.indexPattern.custom.patternLabel', {
      defaultMessage: 'Format'
    })),
    value: pattern,
    placeholder: defaultNumeralPatternInKibana,
    onChange: e => {
      setPattern(e.target.value);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 383,
      columnNumber: 13
    }
  })) : null));
}