"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToRawColorMappingsFn = convertToRawColorMappingsFn;
exports.getUpdatedVisualizationState = getUpdatedVisualizationState;
var _xy = require("./xy");
var _partition = require("./partition");
var _datatable = require("./datatable");
var _tagcloud = require("./tagcloud");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function convertToRawColorMappingsFn(attributes) {
  if (!attributes.state || attributes.visualizationType !== 'lnsXY' && attributes.visualizationType !== 'lnsPie' && attributes.visualizationType !== 'lnsDatatable' && attributes.visualizationType !== 'lnsTagcloud') {
    return attributes;
  }
  const newVisualizationState = getUpdatedVisualizationState(attributes.visualizationType, attributes.state);
  return {
    ...attributes,
    state: {
      ...attributes.state,
      visualization: newVisualizationState
    }
  };
}
function getUpdatedVisualizationState(visualizationType, state) {
  if (!(state !== null && state !== void 0 && state.visualization)) return state.visualization;
  const datasourceStates = state.datasourceStates;
  if (visualizationType === 'lnsXY') {
    const visState = state.visualization;
    return (0, _xy.convertXYToRawColorMappings)(visState, datasourceStates);
  }
  if (visualizationType === 'lnsPie') {
    const visState = state.visualization;
    return (0, _partition.convertPieToRawColorMappings)(visState, datasourceStates);
  }
  if (visualizationType === 'lnsDatatable') {
    const visState = state.visualization;
    return (0, _datatable.convertDatatableToRawColorMappings)(visState, datasourceStates);
  }
  if (visualizationType === 'lnsTagcloud') {
    const visState = state.visualization;
    return (0, _tagcloud.convertTagcloudToRawColorMappings)(visState, datasourceStates);
  }
  return state.visualization;
}