"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultArguments = exports.DEFAULT_TIMEOUT = exports.DEFAULT_OPEN_AI_TEMPERATURE = exports.DEFAULT_OPEN_AI_MODEL = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultArguments = (llmType, temperature, stop, maxTokens) => llmType === 'bedrock' ? {
  temperature: temperature !== null && temperature !== void 0 ? temperature : DEFAULT_BEDROCK_TEMPERATURE,
  stopSequences: stop !== null && stop !== void 0 ? stop : DEFAULT_BEDROCK_STOP_SEQUENCES,
  maxTokens
} : llmType === 'gemini' ? {
  temperature: temperature !== null && temperature !== void 0 ? temperature : DEFAULT_GEMINI_TEMPERATURE
} : {
  n: 1,
  stop: stop !== null && stop !== void 0 ? stop : null,
  temperature: temperature !== null && temperature !== void 0 ? temperature : DEFAULT_OPEN_AI_TEMPERATURE
};
exports.getDefaultArguments = getDefaultArguments;
const DEFAULT_OPEN_AI_TEMPERATURE = exports.DEFAULT_OPEN_AI_TEMPERATURE = 0.2;
// this is a fallback for logging, connector will default to the connector model
// x-pack/platform/plugins/shared/stack_connectors/common/openai/constants.ts
const DEFAULT_OPEN_AI_MODEL = exports.DEFAULT_OPEN_AI_MODEL = 'gpt-4.1';
const DEFAULT_BEDROCK_TEMPERATURE = 0;
const DEFAULT_BEDROCK_STOP_SEQUENCES = ['\n\nHuman:', '\nObservation:'];
const DEFAULT_GEMINI_TEMPERATURE = 0;
const DEFAULT_TIMEOUT = exports.DEFAULT_TIMEOUT = 180000;