"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchDeprecatedApiCounterStats = void 0;
var _server = require("@kbn/usage-collection-plugin/server");
var _counters = require("../common/counters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DEPRECATED_API_COUNTERS_FILTER = `${_server.USAGE_COUNTERS_SAVED_OBJECT_TYPE}.attributes.counterType: deprecated_api_call\\:*`;
const mergeCounter = (counter, acc) => {
  if (acc && (acc === null || acc === void 0 ? void 0 : acc.apiId) !== counter.counterName) {
    throw new Error(`Failed to merge mismatching counterNames: ${acc.apiId} with ${counter.counterName}`);
  }
  const isMarkedCounter = counter.counterType.endsWith(':marked_as_resolved');
  const finalCounter = {
    apiId: counter.counterName,
    apiTotalCalls: 0,
    apiLastCalledAt: 'unknown',
    totalMarkedAsResolved: 0,
    markedAsResolvedLastCalledAt: 'unknown',
    ...(acc || {})
  };
  if (isMarkedCounter) {
    return finalCounter;
  }
  const isResolvedCounter = counter.counterType.endsWith(':resolved');
  const totalKey = isResolvedCounter ? 'totalMarkedAsResolved' : 'apiTotalCalls';
  const lastUpdatedKey = isResolvedCounter ? 'markedAsResolvedLastCalledAt' : 'apiLastCalledAt';
  const newPayload = {
    [totalKey]: (finalCounter[totalKey] || 0) + counter.total,
    [lastUpdatedKey]: counter.lastUpdatedAt
  };
  return {
    ...finalCounter,
    ...newPayload
  };
};
function mergeCounters(counters) {
  const mergedCounters = counters.reduce((acc, counter) => {
    const {
      counterName
    } = counter;
    const existingCounter = acc[counterName];
    acc[counterName] = mergeCounter(counter, existingCounter);
    return acc;
  }, {});
  return Object.values(mergedCounters);
}
const fetchDeprecatedApiCounterStats = logger => {
  return (0, _counters.createCounterFetcher)(logger, DEPRECATED_API_COUNTERS_FILTER, mergeCounters);
};
exports.fetchDeprecatedApiCounterStats = fetchDeprecatedApiCounterStats;