"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventTypes = exports.EventMetric = exports.EventFieldType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let EventMetric = exports.EventMetric = /*#__PURE__*/function (EventMetric) {
  EventMetric["INTERCEPT_TERMINATION_INTERACTION"] = "intercept_termination_interaction";
  EventMetric["INTERCEPT_REGISTRATION"] = "intercept_registration";
  EventMetric["INTERCEPT_OVERLOAD"] = "intercept_overload";
  return EventMetric;
}({});
let EventFieldType = exports.EventFieldType = /*#__PURE__*/function (EventFieldType) {
  EventFieldType["INTERACTION_TYPE"] = "interaction_type";
  EventFieldType["INTERCEPT_ID"] = "intercept_id";
  EventFieldType["INTERACTION_DURATION"] = "interaction_duration";
  return EventFieldType;
}({});
const fields = {
  [EventFieldType.INTERACTION_TYPE]: {
    [EventFieldType.INTERACTION_TYPE]: {
      type: 'keyword',
      _meta: {
        description: 'The type of interaction that occurred with the intercept',
        optional: false
      }
    }
  },
  [EventFieldType.INTERCEPT_ID]: {
    [EventFieldType.INTERCEPT_ID]: {
      type: 'keyword',
      _meta: {
        description: 'ID of the intercept',
        optional: false
      }
    }
  },
  [EventFieldType.INTERACTION_DURATION]: {
    [EventFieldType.INTERACTION_DURATION]: {
      type: 'long',
      _meta: {
        description: 'Duration of the interaction in milliseconds',
        optional: false
      }
    }
  }
};

/**
 * @description defines all the event types that can be reported by the intercept dialog,
 * with the mapping that values provided will be ingested as within EBT
 */
const eventTypes = exports.eventTypes = [{
  eventType: EventMetric.INTERCEPT_TERMINATION_INTERACTION,
  schema: {
    ...fields[EventFieldType.INTERACTION_TYPE],
    ...fields[EventFieldType.INTERCEPT_ID],
    ...fields[EventFieldType.INTERACTION_DURATION]
  }
}, {
  eventType: EventMetric.INTERCEPT_REGISTRATION,
  schema: {
    ...fields[EventFieldType.INTERCEPT_ID]
  }
}, {
  eventType: EventMetric.INTERCEPT_OVERLOAD,
  schema: {
    ...fields[EventFieldType.INTERCEPT_ID]
  }
}];