"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyRelativePathButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/inspect_component/public/components/inspect/flyout/actions_section/copy_relative_path_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const COPIED_RELATIVE_PATH = _i18n.i18n.translate('kbnInspectComponent.inspectFlyout.actionsSection.copyRelativeFilePathCopiedTooltip', {
  defaultMessage: 'Relative file path copied'
});
const COPY_RELATIVE_PATH = _i18n.i18n.translate('kbnInspectComponent.inspectFlyout.actionsSection.copyRelativeFilePathActionTooltip', {
  defaultMessage: 'Copy relative file path'
});
const CopyRelativePathButton = ({
  relativePath
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isTextCopied, setTextCopied] = (0, _react.useState)(false);
  const handleClick = () => {
    (0, _eui.copyToClipboard)(relativePath);
    setTextCopied(true);
  };
  const handleBlur = () => {
    setTextCopied(false);
  };
  const tooltipCss = (0, _react2.css)`
    z-index: calc(${euiTheme.levels.toast} + 3);
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isTextCopied ? COPIED_RELATIVE_PATH : COPY_RELATIVE_PATH,
    css: tooltipCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": COPY_RELATIVE_PATH,
    color: "text",
    iconType: "copy",
    onClick: handleClick,
    onBlur: handleBlur,
    "data-test-subj": "inspectCopyRelativePathButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }));
};
exports.CopyRelativePathButton = CopyRelativePathButton;