"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isIntegrationsPipeline = exports.getErrorText = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getErrorText = error => {
  return error.message && error.message !== '{}' ? error.message : error.error;
};

// All pipleines for integrations end in @custom
exports.getErrorText = getErrorText;
const isIntegrationsPipeline = name => {
  return name.toLowerCase().endsWith('@custom');
};
exports.isIntegrationsPipeline = isIntegrationsPipeline;