"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Reroute = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _shared = require("./shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/reroute.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  maxLengthField
} = _shared_imports.fieldValidators;
const MAX_DATASET_LENGTH = 100;
const MAX_NAMESPACE_LENGTH = 100;
const getFieldsConfig = docService => {
  return {
    /* Optional field configs */
    destination: {
      type: _shared_imports.FIELD_TYPES.TEXT,
      serializer: _shared.from.emptyStringToUndefined,
      label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.reroute.destinationFieldLabel', {
        defaultMessage: 'Destination (optional)'
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.pipelineEditor.reroute.destinationFieldHelperText",
        defaultMessage: "A value for the target index. Not available when {dataset} or {namespace} is set.",
        values: {
          dataset: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 48,
              columnNumber: 22
            }
          }, 'dataset'),
          namespace: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 49,
              columnNumber: 24
            }
          }, 'namespace')
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 9
        }
      })
    },
    dataset: {
      defaultValue: null,
      type: _shared_imports.FIELD_TYPES.COMBO_BOX,
      deserializer: _shared.to.arrayOfStrings,
      serializer: _shared.from.optionalArrayOfStrings,
      label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.reroute.datasetFieldLabel', {
        defaultMessage: 'Dataset (optional)'
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.pipelineEditor.reroute.datasetFieldHelperText",
        defaultMessage: "Field references or a static value for the dataset part of the data stream name. Must meet the criteria for {indexNamesLink}. Cannot contain {dash}. 100 characters max.",
        values: {
          indexNamesLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: `${docService.getIndexParametersUrl()}`,
            target: "_blank",
            external: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 68,
              columnNumber: 15
            }
          }, _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.reroute.indexNameLink', {
            defaultMessage: 'index names'
          })),
          dash: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 74,
              columnNumber: 19
            }
          }, '-')
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 9
        }
      }),
      validations: [{
        validator: maxLengthField({
          length: MAX_DATASET_LENGTH,
          message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.rerouteForm.datasetLengthError', {
            defaultMessage: 'The value must not contain more than 100 characters.'
          })
        })
      }]
    },
    namespace: {
      defaultValue: null,
      type: _shared_imports.FIELD_TYPES.COMBO_BOX,
      deserializer: _shared.to.arrayOfStrings,
      serializer: _shared.from.optionalArrayOfStrings,
      label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.reroute.namespaceFieldLabel', {
        defaultMessage: 'Namespace (optional)'
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.pipelineEditor.reroute.namespaceFieldHelperText",
        defaultMessage: "Field references or a static value for the namespace part of the data stream name. Must meet the criteria for {indexNamesLink}. 100 characters max.",
        values: {
          indexNamesLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: `${docService.getIndexParametersUrl}`,
            target: "_blank",
            external: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 106,
              columnNumber: 15
            }
          }, _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.reroute.indexNameLink', {
            defaultMessage: 'index names'
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 9
        }
      }),
      validations: [{
        validator: maxLengthField({
          length: MAX_NAMESPACE_LENGTH,
          message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.rerouteForm.namespaceLengthError', {
            defaultMessage: 'The value must not contain more than 100 characters.'
          })
        })
      }]
    }
  };
};
const Reroute = () => {
  const form = (0, _shared_imports.useFormContext)();
  const [{
    fields
  }] = (0, _shared_imports.useFormData)({
    watch: ['fields.dataset', 'fields.namespace']
  });
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const fieldsConfig = getFieldsConfig(services.documentation);
  (0, _react.useEffect)(() => {
    if (fields !== null && fields !== void 0 && fields.dataset && fields.dataset.length > 0 || fields !== null && fields !== void 0 && fields.namespace && fields.namespace.length > 0) {
      form.setFieldValue('fields.destination', '');
    }
  }, [form, fields]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "destinationField",
    config: fieldsConfig.destination,
    component: _shared_imports.Field,
    componentProps: {
      euiFieldProps: {
        disabled: (fields === null || fields === void 0 ? void 0 : fields.dataset) && fields.dataset.length > 0 || (fields === null || fields === void 0 ? void 0 : fields.namespace) && fields.namespace.length > 0
      }
    },
    path: "fields.destination",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "datasetField",
    config: fieldsConfig.dataset,
    component: _shared_imports.ComboBoxField,
    componentProps: {
      euiFieldProps: {
        placeholder: '{{data_stream.dataset}}'
      }
    },
    path: "fields.dataset",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "namespaceField",
    config: fieldsConfig.namespace,
    component: _shared_imports.ComboBoxField,
    componentProps: {
      euiFieldProps: {
        placeholder: '{{data_stream.namespace}}'
      }
    },
    path: "fields.namespace",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }));
};
exports.Reroute = Reroute;