"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fieldsConfig = exports.IgnoreMissingField = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../../shared_imports");
var _shared = require("../shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/common_fields/ignore_missing_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const fieldsConfig = exports.fieldsConfig = {
  ignore_missing: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: false,
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(false),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.commonFields.ignoreMissingFieldLabel', {
      defaultMessage: 'Ignore missing'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.commonFields.ignoreMissingFieldHelpText",
      defaultMessage: "Ignore documents with a missing {field}.",
      values: {
        field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 37,
            columnNumber: 18
          }
        }, 'field')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 7
      }
    })
  }
};
const IgnoreMissingField = props => /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
  config: {
    ...fieldsConfig.ignore_missing,
    ...props
  },
  component: _shared_imports.ToggleField,
  path: "fields.ignore_missing",
  "data-test-subj": "ignoreMissingSwitch",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 47,
    columnNumber: 3
  }
});
exports.IgnoreMissingField = IgnoreMissingField;