"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateStringAssetFilters = validateStringAssetFilters;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateStringAssetFilters(q, res) {
  try {
    if (!q.filters) return [res.badRequest(new Error(`filters is required`))];
    const parsedFilters = JSON.parse(q.filters);
    return [null, parsedFilters];
  } catch (err) {
    return [res.badRequest(err)];
  }
}