"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initInventoryViewRoutes = void 0;
var _create_inventory_view = require("./create_inventory_view");
var _delete_inventory_view = require("./delete_inventory_view");
var _find_inventory_view = require("./find_inventory_view");
var _get_inventory_view = require("./get_inventory_view");
var _update_inventory_view = require("./update_inventory_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initInventoryViewRoutes = dependencies => {
  (0, _create_inventory_view.initCreateInventoryViewRoute)(dependencies);
  (0, _delete_inventory_view.initDeleteInventoryViewRoute)(dependencies);
  (0, _find_inventory_view.initFindInventoryViewRoute)(dependencies);
  (0, _get_inventory_view.initGetInventoryViewRoute)(dependencies);
  (0, _update_inventory_view.initUpdateInventoryViewRoute)(dependencies);
};
exports.initInventoryViewRoutes = initInventoryViewRoutes;