"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHosts = void 0;
var _get_filtered_hosts = require("./get_filtered_hosts");
var _get_all_hosts = require("./get_all_hosts");
var _get_hosts_alerts_count = require("./get_hosts_alerts_count");
var _utils = require("../utils");
var _get_apm_hosts = require("./get_apm_hosts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHosts = async ({
  metrics,
  from,
  to,
  limit,
  query,
  alertsClient,
  apmDataAccessServices,
  infraMetricsClient,
  schema
}) => {
  const apmDocumentSources = await (apmDataAccessServices === null || apmDataAccessServices === void 0 ? void 0 : apmDataAccessServices.getDocumentSources({
    start: from,
    end: to
  }));
  const hostNames = await getHostNames({
    infraMetricsClient,
    apmDataAccessServices,
    apmDocumentSources,
    from,
    to,
    limit,
    query,
    schema
  });
  if (hostNames.length === 0) {
    return {
      entityType: 'host',
      nodes: []
    };
  }
  const [hostMetricsResponse, alertsCountResponse] = await Promise.all([(0, _get_all_hosts.getAllHosts)({
    infraMetricsClient,
    apmDocumentSources,
    from,
    to,
    limit,
    metrics,
    hostNames,
    schema
  }), (0, _get_hosts_alerts_count.getHostsAlertsCount)({
    alertsClient,
    hostNames,
    from,
    to,
    limit
  })]);
  const alertsByHostName = alertsCountResponse.reduce((acc, {
    name,
    alertsCount
  }) => {
    acc[name] = {
      alertsCount
    };
    return acc;
  }, {});
  const hosts = hostMetricsResponse.map(host => {
    var _alertsByHostName$hos;
    const {
      alertsCount
    } = (_alertsByHostName$hos = alertsByHostName[host.name]) !== null && _alertsByHostName$hos !== void 0 ? _alertsByHostName$hos : {};
    return {
      ...host,
      alertsCount
    };
  });
  return {
    entityType: 'host',
    nodes: hosts
  };
};
exports.getHosts = getHosts;
const getHostNames = async ({
  infraMetricsClient,
  apmDataAccessServices,
  apmDocumentSources,
  from,
  to,
  limit,
  query,
  schema = 'ecs'
}) => {
  (0, _utils.assertQueryStructure)(query);
  const hasSystemIntegrationData = await (0, _get_filtered_hosts.getHasDataFromSystemIntegration)({
    infraMetricsClient,
    from,
    to,
    query,
    schema
  });
  const [monitoredHosts, apmHosts] = await Promise.all([hasSystemIntegrationData ? (0, _get_filtered_hosts.getFilteredHostNames)({
    infraMetricsClient,
    query,
    from,
    to,
    limit,
    schema
  }) : undefined, apmDataAccessServices && apmDocumentSources ? (0, _get_apm_hosts.getApmHostNames)({
    apmDataAccessServices,
    apmDocumentSources,
    query,
    from,
    to,
    limit
  }) : undefined]);
  return [...new Set([...(monitoredHosts !== null && monitoredHosts !== void 0 ? monitoredHosts : []), ...(apmHosts !== null && apmHosts !== void 0 ? apmHosts : [])])];
};